/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.New;
import org.h2.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    private static final boolean ALLOW_ALL;
    private static final HashSet<String> ALLOWED_CLASS_NAMES;
    private static final String[] ALLOWED_CLASS_NAME_PREFIXES;

    private ClassUtils() {
    }

    public static Class<?> loadSystemClass(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public static Class<?> loadUserClass(String string) throws SQLException {
        if (!ALLOW_ALL && !ALLOWED_CLASS_NAMES.contains(string)) {
            boolean bl = false;
            for (String string2 : ALLOWED_CLASS_NAME_PREFIXES) {
                if (!string.startsWith(string2)) continue;
                bl = true;
            }
            if (!bl) {
                throw Message.getSQLException(90134, string);
            }
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception exception) {
                throw Message.getSQLException(90086, classNotFoundException, string);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw Message.getSQLException(90086, noClassDefFoundError, string);
        }
    }

    public static boolean isVarArgs(Method method) {
        if ("1.5".compareTo(SysProperties.JAVA_SPECIFICATION_VERSION) > 0) {
            return false;
        }
        try {
            Method method2 = method.getClass().getMethod("isVarArgs", new Class[0]);
            Boolean bl = (Boolean)method2.invoke((Object)method, new Object[0]);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        ALLOWED_CLASS_NAMES = New.hashSet();
        String string = SysProperties.ALLOWED_CLASSES;
        ArrayList<String> arrayList = New.arrayList();
        boolean bl = false;
        for (String string2 : StringUtils.arraySplit(string, ',', true)) {
            if (string2.equals("*")) {
                bl = true;
                continue;
            }
            if (string2.endsWith("*")) {
                arrayList.add(string2.substring(0, string2.length() - 1));
                continue;
            }
            ALLOWED_CLASS_NAMES.add(string2);
        }
        ALLOW_ALL = bl;
        ALLOWED_CLASS_NAME_PREFIXES = new String[arrayList.size()];
        arrayList.toArray(ALLOWED_CLASS_NAME_PREFIXES);
    }
}

