#! /bin/sh

main() {

##### 初期設定 #####
OS_LANG=UTF-8
OPENSTANDIA_INSTALLER_VER=3.0.0.0beta
STACK_XML=stack-${OPENSTANDIA_INSTALLER_VER}.xml
LICENSE_FILE=license.txt
ANT_DIR=apache-ant-1.7.0
SCRIPTS_DIR=scripts
OPENOLAP_NO=2


##### 初期処理 #####
CURRENT_DIR=`pwd`
ANT_HOME=${CURRENT_DIR}/lib/${ANT_DIR}
_PATH=${PATH}
PATH=${ANT_HOME}/bin:${CURRENT_DIR}/bin:${PATH}
export PATH
_SCRIPTS_DIR=${SCRIPTS_DIR}
SCRIPTS_DIR=${CURRENT_DIR}/${SCRIPTS_DIR}/
export SCRIPTS_DIR

chmod 755 "${ANT_HOME}/bin/ant" > /dev/nul
set_lang_func


##### 実行ユーザー権限チェック #####
sh ${CURRENT_DIR}/bin/CheckAuthority.sh
if [ $? -ne 0 ]; then
	echo 実行ユーザーがrootでないため処理を続行できません。
	end_func
fi


##### javaインストールチェック #####
sh ${CURRENT_DIR}/bin/CheckInstalledJava.sh
if [ $? -ne 0 ]; then
	echo javaがインストールされていないため処理を続行できません。
	end_func
fi


##### 画面表示 #####
clear
echo OpenStandia Ver.${OPENSTANDIA_INSTALLER_VER}
echo 各種OSSのインストール、アンインストール、アップデート処理をします。
echo 
echo 処理を選択してください。
echo 1 : インストール
echo 2 : アンインストール
echo 3 : アップデート
read MODE_NO
if [ "${MODE_NO}" = "" ]; then
	MODE_NO=1
fi
if [ "${MODE_NO}" = "1" ]; then
	MODE=install
	MODE_STR=インストール
fi
if [ "${MODE_NO}" = "2" ]; then
	MODE=uninstall
	MODE_STR=アンインストール
fi
if [ "${MODE_NO}" = "3" ]; then
	MODE=update
	MODE_STR=アップデート
fi


##### ライセンス表示 ######
if [ "${MODE}" = "install" ]; then
	clear
	iconv -f SHIFT_JIS -t ${OS_LANG} "${LICENSE_FILE}" | more
	read -p "同意しますか？(y/n) [n]" RESULT
	if [ "${RESULT}" = "y" ]; then
		echo 処理を継続します。 > /dev/nul
	else
		end_func
	fi
fi


##### インストール全体前処理 #####
echo 
ant -Dmode=${MODE} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install-before.xml"
if [ $? -ne 0 ]; then error_func; fi


##### ant実行 #####
echo 
echo ダウンロード処理を開始します...
ant -Dno=${OPENOLAP_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
if [ $? -ne 0 ]; then error_func; fi


##### インストール実行 #####
INSTALLED_NO=
echo 
echo ${MODE_STR}処理を開始します...
ant -Dno=${OPENOLAP_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
if [ $? -ne 0 ]; then error_func; fi
INSTALLED_NO=${INSTALLED_NO},${OPENOLAP_NO}


##### インストール全体後処理 #####
echo 
ant -Dmode=${MODE} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install-after.xml"
if [ $? -ne 0 ]; then error_func; fi


##### 後処理 #####
end_func

}


##### 終了処理 #####
finally_func () {
	PATH=${_PATH}
	export PATH
	SCRIPTS_DIR=${_SCRIPTS_DIR}
	export SCRIPTS_DIR

	echo ${MODE_STR}処理を終了しました...
}


##### 正常終了 #####
end_func () {
	finally_func
	exit 0
}


##### 異常終了 #####
error_func () {
	echo ${MODE_STR}処理の途中で異常が発生しました...
	finally_func
	exit 1
}


##### 文字コード設定 #####
set_lang_func () {
	_OS_LANG=`echo ${LANG} | awk -F '.' '{print $2;}'`
	if [ "${_OS_LANG}" = "" ]; then
		echo 処理なし > /dev/nul
	else
		OS_LANG=${_OS_LANG}
	fi
}

main $*
