#! /bin/sh

main() {

##### 初期設定 #####
BIN_DIR=bin
JBOSS_EXE=run.sh
LOG=jboss-shutdown.log
LOOP_NUM=12
NOPAUSE=y

##### 引数取得 #####
PRODUCT_NAME=$1
PRODUCT_VER=$2
TMP_DIR=$3
SRC_DIR=$4
JBOSS_HOME=$5
BUILD_XML=$6
ANT_ARGS=$7

##### 初期処理 #####
TMP_DIR=${TMP_DIR}/
SRC_DIR=${SRC_DIR}/
ANT_ARGS=`echo "${ANT_ARGS}" | sed -e "s/\\\\\\\\/ /g"`

##### 存在チェック #####
cd "${JBOSS_HOME}/${BIN_DIR}"
if [ ! -f "${JBOSS_EXE}" ]; then
	echo JBossがインストールされていません。
	exit 0
fi

##### JBossの強制終了を試みる #####
"${JBOSS_HOME}bin/shutdown.sh" -S 2> /dev/nul
EXIT_CODE=$?
if [ "${EXIT_CODE}" = "0" ]; then
	rm -f "${TMP_DIR}${LOG}"
	for i in `seq 1 ${LOOP_NUM}`; do
		sleep 5
		"${JBOSS_HOME}bin/shutdown.sh" -S 2>> "${TMP_DIR}${LOG}"
		grep 'Connection refused' "${TMP_DIR}${LOG}" > /dev/nul
		EXIT_CODE=$?
		if [ "${EXIT_CODE}" = "0" ]; then
			echo JBossの終了確認ができました。
			break
		else
			if [ "${i}" = "${LOOP_NUM}" ]; then
				echo JBossの終了確認ができませんでした。
				break
			fi
			echo "JBossの終了確認ができないためリトライします。(${i})"
		fi
	done
	rm -f "${TMP_DIR}${LOG}"
else
	echo JBossは起動していません。
fi

}

main $*
