package jp.ossc.installer.gui.thread;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import jp.ossc.installer.gui.log.LogInputStream;

/**
 * Ost@CʃXbhŎsNXłB<br>
 * @author S.Fujii
 * @version 1.0
 * @since 1.0
 */
public class ProcessThread extends Thread {

    /**
     * sR}hƈ<br>
     */
    private String[] args;

    /**
     * sۂ̊ϐ<br>
     */
    private String[] envp;

    /**
     * sʂۑꂽStream<br>
     */
    private LogInputStream logInputStream;

    /**
     * G[̎sʂۑꂽStream<br>
     */
    private LogInputStream errorInputStream;

    /**
     * IR[h<br>
     */
    private int exitValue;

    /**
     * sǂ<br>
     * true : s / false : s<br>
     */
    private boolean executing;

    /**
     * RXgN^[<br>
     * @param args sR}hƈ
     * @param envp sۂ̊ϐ
     */
    public ProcessThread (String[] args, String[] envp) {
        super();
        this.args = args;
        this.envp = envp;
        logInputStream = null;
        executing = true;
        exitValue = 1;
    }

    /**
     * sʂۑꂽStream擾<br>
     * @return sʂۑꂽStream
     */
    public LogInputStream getLogInputStream() {
        while (executing && logInputStream == null) {
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                // Ȃ
            }
        }
        return logInputStream;
    }

    /**
     * G[̎sʂۑꂽStream擾<br>
     * @return G[̎sʂۑꂽStream
     */
    public LogInputStream getErrorInputStream() {
        while (executing && errorInputStream == null) {
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                // Ȃ
            }
        }
        return errorInputStream;
    }

    /**
     * IR[h擾<br>
     * @return IR[h
     */
    public int getExitValue() {
        return exitValue;
    }

    /**
     * s<br>
     * @see java.lang.Runnable#run()
     */
    public void run() {

        // Os
        Process proc = runtimeExec();

        // eXg[擾
        InputStream input = proc.getInputStream();
        InputStream error = proc.getErrorStream();
        OutputStream output = proc.getOutputStream();

        // InputStreamf[^Ɏ擾
        // waitForgpꍇ́AInputStreamɎ擾ĂȂƃfbhbN
        InputStreamThread inputThread = new InputStreamThread(input);
        InputStreamThread errorThread = new InputStreamThread(error);
        inputThread.start();
        errorThread.start();
        logInputStream = inputThread.getLogInputStream();
        errorInputStream = errorThread.getLogInputStream();

        // fobO[h̏ꍇ́AƊϐo͂
        outputArgsAndEnvp();

        try {
            // TuvȌI҂
            proc.waitFor();
            exitValue = proc.exitValue();
        } catch (InterruptedException e) {
            proc.destroy();
            inputThread.stopThread();
        } finally {
            logInputStream.eos();
            errorInputStream.eos();
            try {
                input.close();
            } catch (Exception e) {
                // Ȃ
            }
            try {
                error.close();
            } catch (Exception e) {
                // Ȃ
            }
            try {
                output.close();
            } catch (Exception e) {
                // Ȃ
            }
            executing = false;
        }

    }

    /**
     * Ost@C̎s<br>
     * @return vZX
     */
    protected Process runtimeExec() {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(args, envp);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return proc;
    }

    /**
     * ϐOɏo͂<br>
     */
    protected void outputArgsAndEnvp() {
        for (int i = 0; i < args.length; i++) {
            final String log = "args[" + i + "] :" + args[i];
            outputDebugLog(log);
        }
        for (int i = 0; i < envp.length; i++) {
            final String log = "envp[" + i + "] :" + envp[i];
            outputDebugLog(log);
        }
    }

    /**
     * fobOO擾<br>
     * @param log o͕
     */
    protected void outputDebugLog(final String log) {
        final boolean dubug = Boolean.valueOf(System.getProperty("debug"));
        if (logInputStream != null && dubug) {
            logInputStream.append(log);
        } else {
            // Ȃ
        }
    }

}
