package jp.ossc.installer.gui.log;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * OInputStreamNXłB<br>
 * @author S.Fujii
 * @version 1.0
 * @since 1.0
 */
public class LogInputStream implements Closeable {

    /**
     * bNIuWFNg<br>
     */
    private Object lock = new Object();

    /**
     * StreamĂ邩ǂ<br>
     * true : Ă / false : ĂȂ<br>
     */
    private boolean closed = false;

    /**
     * Stream̖[<br>
     */
    private boolean eos = false;

    /**
     * OێList<br>
     */
    private List<String> list;

    /**
     * RXgN^[<br>
     */
    public LogInputStream () {
        super();
        closed = false;
        eos = false;
        list = new ArrayList<String>();
    }

    /**
     * Stream1s̃f[^ǉ<br>
     * @param str ǉf[^
     */
    public void append(final String str) {
        synchronized (lock) {
            list.add(str);
        }
    }

    /**
     * Stream̖[ł邱Ƃm点<br>
     */
    public void eos() {
        this.eos = true;
    }

    /**
     * Stream1s̃f[^擾<br>
     * @return f[^
     */
    public String readLine() {
        String str = null;
        while (true) {
            if (list.size() > 0) {
                synchronized (lock) {
                    str = list.get(0);
                    list.remove(0);
                }
                break;
            } else if (list.size() == 0 && isEos()) {
                str = null;
                break;
            } else if (isClosed()) {
                str = null;
                break;
            } else {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    // Ȃ
                }
            }
        }
        return str;
    }

    /**
     * Xg[<br>
     * @throws IOException
     * @see java.io.Closeable#close()
     */
    public void close() throws IOException {
        if (isClosed()) {
            throw new IOException("Xg[͊ɕĂ܂B");
        } else {
            closed = true;
        }
    }

    /**
     * Xg[Ă邩ǂ<br>
     * @return true : Ă / false : ĂȂ
     */
    public boolean isClosed() {
        return closed;
    }

    /**
     * Stream̖[܂łǂ<br>
     * @return true : [܂ŗĂ / false : ĂȂ
     */
    protected boolean isEos() {
        return eos;
    }

}
