package jp.ossc.installer.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.ossc.installer.gui.thread.ProcessThread;
import jp.ossc.installer.gui.thread.WatchProcessThread;

/**
 * ZbgAbvNXłB<br>
 * @author S.Fujii
 * @version 1.0
 * @since 1.0
 */
public class Setup {

    /**
     *  : CXg[O<br>
     */
    public static final int TYPE_INSTALL_BEFORE = 0;

    /**
     *  : _E[h<br>
     */
    public static final int TYPE_DOWNLOAD = 1;

    /**
     *  : CXg[<br>
     */
    public static final int TYPE_INSTALL = 2;

    /**
     *  : CXg[㏈<br>
     */
    public static final int TYPE_INSTALL_AFTER = 3;

    /**
     * [h : CXg[<br>
     */
    public static final int MODE_INSTALL = 0;

    /**
     * [h : ACXg[<br>
     */
    public static final int MODE_UNINSTALL = 1;

    /**
     * [h : Abvf[g<br>
     */
    public static final int MODE_UPDATE = 2;

    /**
     * ANT_HOMEfBNg<br>
     */
    private static final String ANT_DIR = "lib/apache-ant-1.7.0/";

    /**
     * scriptsfBNg<br>
     */
    private static final String SCRIPTS_DIR = "scripts/";

    /**
     * WindowspϐGXP[vJn<br>
     */
    private static final String ESC_WINDOWS_START = "%";

    /**
     * WindowspϐGXP[vI<br>
     */
    private static final String ESC_WINDOWS_END = "%";

    /**
     * LinuxpϐGXP[vJn<br>
     */
    private static final String ESC_LINUX_START = "${";

    /**
     * LinuxpϐGXP[vI<br>
     */
    private static final String ESC_LINUX_END = "}";

    /**
     * =<br>
     */
    private static final String EQUAL = "=";

    /**
     * OS̎ނ𔻒fۂɎgp镶 : windows<br>
     */
    private static final String OS_WINDOWS = "windows";

    /**
     * Ants̈Astack.xmlw: -f<br>
     */
    private static final String ARG_F = "-f";

    /**
     * Ants̈AOSSԍ : -Dno=<br>
     */
    private static final String ARG_NO = "-Dno=";

    /**
     * Ants̈Aݒt@CI : -Dsub=<br>
     */
    private static final String ARG_SUB = "-Dsub=";

    /**
     * Ants̈A[h : -Dmode=<br>
     */
    private static final String ARG_MODE = "-Dmode=";

    /**
     * Ants̈Astack.xmlt@Cw : -DstackXml=<br>
     */
    private static final String ARG_STACK_XML = "-DstackXml=";

    /**
     * Ants̈ACXg[ꂽOSSԍ(J}؂) : -DinstalledNo=<br>
     */
    private static final String ARG_INSTALLED_NO = "-DinstalledNo=";

    /**
     * Ants̈A_E[ĥ݃tO : -DdownloadOnly=<br>
     */
    private static final String ARG_DOWNLOAD_ONLY = "-DdownloadOnly=";

    /**
     * 荞݂𔭐܂ł̃ftHg(ms)<br>
     */
    private static final int DEFAULT_TIMEOUT_MS = 5 * 60 * 1000;

    /**
     * VXevpeBvZX^CAEgԂ擾̃L[<br>
     */
    private static final String SYSTEM_PROPERTY_PROCESS_TIMEOUT_KEY = "processTimeout";

    /**
     * CXg[Os<br>
     * @param mode MODE_INSTALL / MODE_UNINSTALL / MODE_UPDATE
     * @return sXbh
     * @throws IOException IOException
     * @throws InterruptedException InterruptedException
     */
    public static ProcessThread execInstallBefore(final int mode)
        throws IOException, InterruptedException {
        return exec(TYPE_INSTALL_BEFORE, -1, -1, mode, null);
    }

    /**
     * _E[hs<br>
     * @param no OSSԍ
     * @return sXbh
     * @throws IOException IOException
     * @throws InterruptedException InterruptedException
     */
    public static ProcessThread execDownload(final int no)
        throws IOException, InterruptedException {
        return exec(TYPE_DOWNLOAD, no, -1, -1, null);
    }

    /**
     * CXg[s<br>
     *  ݒt@CIȂ<br>
     * @param no OSSԍ
     * @param mode MODE_INSTALL / MODE_UNINSTALL / MODE_UPDATE
     * @param installedNo CXg[ƑIOSSԍJ}؂ɂ () 1,2,3Ȃ
     * @return sXbh
     * @throws IOException IOException
     * @throws InterruptedException InterruptedException
     */
    public static ProcessThread execInstall(final int no, final int mode,
            final String installedNo) throws IOException,
        InterruptedException {
        return execInstall(no, -1, mode, installedNo);
    }

    /**
     * CXg[s<br>
     *  ݒt@CI<br>
     * @param no OSSԍ
     * @param sub Iݒt@Cԍ(conf)
     * @param mode MODE_INSTALL / MODE_UNINSTALL / MODE_UPDATE
     * @param installedNo CXg[ƑIOSSԍJ}؂ɂ () 1,2,3Ȃ
     * @return sXbh
     * @throws IOException IOException
     * @throws InterruptedException InterruptedException
     */
    public static ProcessThread execInstall(final int no, final int sub,
            final int mode, final String installedNo) throws IOException,
        InterruptedException {
        return exec(TYPE_INSTALL, no, sub, mode, installedNo);
    }

    /**
     * CXg[㏈s<br>
     * @param mode MODE_INSTALL / MODE_UNINSTALL / MODE_UPDATE
     * @return sXbh
     * @throws IOException IOException
     * @throws InterruptedException InterruptedException
     */
    public static ProcessThread execInstallAfter(final int mode)
        throws IOException, InterruptedException {
        return exec(TYPE_INSTALL_AFTER, -1, -1, mode, null);
    }

    /**
     * Ants<br>
     * @param type sXNvg̎
     * @param no OSSԍ
     * @param sub Iݒt@Cԍ(conf)
     * @param mode MODE_INSTALL / MODE_UNINSTALL / MODE_UPDATE
     * @param installedNo CXg[ƑIOSSԍJ}؂ɂ () 1,2,3Ȃ
     * @return sXbh
     * @throws IOException IOException
     * @throws InterruptedException InterruptedException
     */
    public static ProcessThread exec(final int type, final int no,
            final int sub, final int mode, final String installedNo)
        throws IOException, InterruptedException {
        List<String> argList = new ArrayList<String>();

        // OS擾
        final String osName = getOsName();

        // OSɂNVFύX
        if (osName.contains(OS_WINDOWS)) {
            argList.add("cmd.exe");
            argList.add("/c");
            argList.add("call");
        } else {
            argList.add("sh");
        }

        // fobO[h̏ꍇ́AR\[\(Winodowŝ)
        final boolean dubug = Boolean.valueOf(System.getProperty("debug"));
        if (dubug) {
            if (osName.contains(OS_WINDOWS)) {
                argList.add("start");
            } else {
                // Ȃ
            }
        } else {
            // Ȃ
        }

        // AntgݗĂ
        argList.add("ant");
        argList.add(ARG_F);
        final String envScriptsDir = escEnvStr("SCRIPTS_DIR");
        if (type == TYPE_INSTALL_BEFORE) {
            argList.add(envScriptsDir + "/install-before.xml");
            argList.add(ARG_MODE + getModeStr(mode));
        } else if (type == TYPE_INSTALL_AFTER) {
            argList.add(envScriptsDir + "/install-after.xml");
            argList.add(ARG_MODE + getModeStr(mode));
        } else if (type == TYPE_DOWNLOAD) {
            argList.add(envScriptsDir + "/download.xml");
            argList.add(ARG_NO + no);
        } else {
            argList.add(envScriptsDir + "/install.xml");
            argList.add(ARG_NO + no);
            if (sub < 0) {
                // Ȃ
            } else {
                argList.add(ARG_SUB + sub);
            }
            argList.add(ARG_MODE + getModeStr(mode));
            if (installedNo == null) {
                // Ȃ
            } else {
                argList.add(ARG_INSTALLED_NO + "\"" + installedNo + "\"");
            }
        }
        final String stackXmlFileName = System
                .getProperty("user.stackxmlfile.name");
        if (stackXmlFileName == null) {
            // Ȃ
        } else {
            argList.add(ARG_STACK_XML + stackXmlFileName);
        }
        final boolean downloadOnly = Boolean.valueOf(System
                .getProperty("downloadOnly"));
        if (downloadOnly) {
            argList.add(ARG_DOWNLOAD_ONLY + "true");
        } else {
            // Ȃ
        }

        // zɕϊ
        final String[] args = (String[]) argList.toArray(new String[0]);

        // s
        return exec(args);
    }

    /**
     * Ants<br>
     * @param args 
     * @return sXbh
     * @throws IOException IOException
     * @throws InterruptedException InterruptedException
     */
    public static ProcessThread exec(final String[] args) throws IOException,
        InterruptedException {

        // OS̊ϐ𑍂Ď擾
        List<String> envList = getEnvAll();

        // ϐ̂PATH擾
        final int pathIndex = getIndexFromEnvList(envList, "PATH");
        String path = envList.get(pathIndex);
        removeFromEnvList(envList, "PATH");

        // ̊ϐŕsvȂ̂폜
        removeFromEnvList(envList, "ANT_HOME");
        removeFromEnvList(envList, "SCRIPTS_DIR");

        // ϐVɒǉ
        final String userDir = System.getProperty("user.dir") + "/";
        final String osName = getOsName();
        envList.add("ANT_HOME=" + userDir + ANT_DIR);
        envList.add("SCRIPTS_DIR=" + userDir + SCRIPTS_DIR);
        if (osName.contains(OS_WINDOWS)) {
            envList.add(path + ";" + userDir + ANT_DIR + "bin;" + userDir
                        + "bin;");
        } else {
            envList.add(path + ":" + userDir + ANT_DIR + "bin:" + userDir
                        + "bin:");
        }

        // zɕϊ
        final String[] envp = (String[]) envList.toArray(new String[0]);

        // ʃXbhɂAntsȂ炳ɕʃXbhł̃XbhĎ
        final int processTimeout = getProcessTimeout();
        ProcessThread processThread = new ProcessThread(args, envp);
        WatchProcessThread watchTread = new WatchProcessThread(
            processThread, processTimeout);
        processThread.start();
        watchTread.start();

        // Ԃl̐ݒ
        return processThread;

    }

    /**
     * CXg[ʂlantɓnp̕ɕϊʂԂ<br>
     * @param mode CXg[ʂl
     * @return antɓnp̕
     */
    protected static String getModeStr(final int mode) {
        String modeStr = null;
        if (mode == MODE_UNINSTALL) {
            modeStr = "uninstall";
        } else if (mode == MODE_UPDATE) {
            modeStr = "update";
        } else {
            modeStr = "install";
        }
        return modeStr;
    }

    /**
     * OS̊ϐ𑍂Ď擾<br>
     * @return OS̊ϐ
     */
    protected static List<String> getEnvAll() {
        final Map envMap = System.getenv();
        List<String> envList = new ArrayList<String>();
        for (Iterator it = envMap.entrySet().iterator(); it.hasNext();) {
            Map.Entry entry = (Map.Entry) it.next();
            final String key = (String) entry.getKey();
            final String value = (String) entry.getValue();
            envList.add(key + EQUAL + value);
        }
        return envList;
    }

    /**
     * OS̊ϐێĂList<br>
     * w肳ꂽϐi[Ăindex擾<br>
     *  Aw肵ϐ݂Ȃꍇ́A-1ԋp<br>
     * @param envList OS̊ϐ
     * @param envName 擾ϐ
     * @return PATHi[Ăindex
     */
    protected static int getIndexFromEnvList(final List<String> envList,
            final String envName) {
        int returnIndex = -1;
        if (envList == null || envName == null) {
            returnIndex = -1;
        } else {
            final int num = envList.size();
            for (int i = 0; i < num; i++) {
                final String env = envList.get(i).toUpperCase();
                final String lEnvName = envName.toUpperCase();
                if (env.startsWith(lEnvName + "=")) {
                    returnIndex = i;
                    break;
                } else {
                    // Ȃ
                }
            }
        }
        return returnIndex;
    }

    /**
     * OS̊ϐێĂList炠ϐ폜<br>
     * @param envList OS̊ϐ
     * @param envName 폜ϐ
     */
    protected static void removeFromEnvList(List<String> envList,
            final String envName) {
        final int index = getIndexFromEnvList(envList, envName);
        if (index > -1) {
            envList.remove(index);
        } else {
            // Ȃ
        }
    }

    /**
     * VXevpeBOS擾<br>
     *  A擾łȂꍇ͋󕶎ԋp<br>
     * @return OS
     */
    protected static String getOsName() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            osName = "";
        } else {
            // Ȃ
        }
        return osName.toLowerCase();
    }

    /**
     * OSɏ]ĊϐGXP[v<br>
     * @param envStr GXP[vϐ
     * @return GXP[vꂽϐ
     */
    protected static String escEnvStr(final String envStr) {
        String escEnvStr = null;
        if (envStr == null) {
            escEnvStr = null;
        } else {
            final String osName = getOsName();
            if (osName.contains(OS_WINDOWS)) {
                escEnvStr = ESC_WINDOWS_START + envStr + ESC_WINDOWS_END;
            } else {
                escEnvStr = ESC_LINUX_START + envStr + ESC_LINUX_END;
            }
        }
        return escEnvStr;
    }

    /**
     * VXevpeBvZX^CAEgԂ擾<br>
     * @return vZX^CAEg
     */
    protected static int getProcessTimeout() {
        final String processTimeoutStr = System
                .getProperty(SYSTEM_PROPERTY_PROCESS_TIMEOUT_KEY);
        int processTimeout = 0;
        try {
            processTimeout = Integer.parseInt(processTimeoutStr);
        } catch (Exception e) {
            processTimeout = DEFAULT_TIMEOUT_MS;
        }
        return processTimeout;
    }

}
