#! /bin/sh

main() {

##### 初期設定 #####
OS_LANG=UTF-8
OPENSTANDIA_INSTALLER_VER=sample
STACK_XML=stack-${OPENSTANDIA_INSTALLER_VER}.xml
ANT_DIR=apache-ant-1.7.0
SCRIPTS_DIR=scripts
CHECK_ANT_NO=2
KICK_EXE_NO=4
KICK_SHELL_NO=6
UNZIP_TEST_NO=8
REPLACE_TEST_NO=10
SELECT_CONFIG_NO=12
DEPEND_DEST_NO=14
DEPEND_SRC_NO=16


##### 初期処理 #####
CURRENT_DIR=`pwd`
ANT_HOME=${CURRENT_DIR}/lib/${ANT_DIR}
export ANT_HOME
_PATH=${PATH}
PATH=${ANT_HOME}/bin:${CURRENT_DIR}/bin:${PATH}
export PATH
_SCRIPTS_DIR=${SCRIPTS_DIR}
SCRIPTS_DIR=${CURRENT_DIR}/${SCRIPTS_DIR}/
export SCRIPTS_DIR

chmod 755 "${ANT_HOME}/bin/ant" > /dev/nul
set_lang_func


##### 実行ユーザー権限チェック #####
sh ${CURRENT_DIR}/bin/CheckAuthority.sh
if [ $? -ne 0 ]; then
	echo 実行ユーザーがrootでないため処理を続行できません。
	end_func
fi


##### javaインストールチェック #####
sh ${CURRENT_DIR}/bin/CheckInstalledJava.sh
if [ $? -ne 0 ]; then
	echo javaがインストールされていないため処理を続行できません。
	end_func
fi


##### 画面表示 #####
clear
echo OpenStandiaInstaller サンプルスタック
echo OpenStandiaInstallerによるサンプルです。
echo 
echo 処理を選択してください。
echo 1 : インストール
echo 2 : アンインストール
echo 3 : アップデート
read MODE_NO
if [ "${MODE_NO}" = "" ]; then
	MODE_NO=1
fi
if [ "${MODE_NO}" = "1" ]; then
	MODE=install
	MODE_STR=インストール
fi
if [ "${MODE_NO}" = "2" ]; then
	MODE=uninstall
	MODE_STR=アンインストール
fi
if [ "${MODE_NO}" = "3" ]; then
	MODE=update
	MODE_STR=アップデート
fi


##### インストール全体前処理 #####
echo 
ant -Dmode=${MODE} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install-before.xml"
if [ $? -ne 0 ]; then error_func; fi


##### 問い合わせ #####
clear
# check-ant
read -p "Antのバージョンを表示するサンプルを実行しますか？(y/n) [y]" CHECK_ANT
if [ "${CHECK_ANT}" = "" ]; then
	CHECK_ANT=y
fi

# kick-exe
read -p "実行ファイルを実行するサンプルを実行しますか？(y/n) [y]" KICK_EXE
if [ "${KICK_EXE}" = "" ]; then
	KICK_EXE=y
fi

# kick-shell
read -p "シェルファイルを実行するサンプルを実行しますか？(y/n) [y]" KICK_SHELL
if [ "${KICK_SHELL}" = "" ]; then
	KICK_SHELL=y
fi

# unzip-test
read -p "ZIPファイルを展開するサンプルを実行しますか？(y/n) [y]" UNZIP_TEST
if [ "${UNZIP_TEST}" = "" ]; then
	UNZIP_TEST=y
fi

# replace-test
read -p "文字列置換を展開するサンプルを実行しますか？(y/n) [y]" REPLACE_TEST
if [ "${REPLACE_TEST}" = "" ]; then
	REPLACE_TEST=y
fi

# select-config
read -p "設定ファイルを選択させるサンプルを実行しますか？(y/n) [y]" SELECT_CONFIG
if [ "${SELECT_CONFIG}" = "" ]; then
	SELECT_CONFIG=y
fi
SELECT_CONFIG_CONF=1
if [ "${SELECT_CONFIG}" = "y" ]; then
	echo 設定ファイルを選択してください。
	echo 1 : 1番目の設定
	echo 2 : 2番目の設定
	echo 3 : 3番目の設定
	echo 4 : 4番目の設定
	echo 5 : 5番目の設定
	read SELECT_CONFIG_CONF
fi

# depend-dest
read -p "依存先を${MODE_STR}しますか？(y/n) [y]" DEPEND_DEST
if [ "${DEPEND_DEST}" = "" ]; then
	DEPEND_DEST=y
fi

# depend-src
read -p "依存元を${MODE_STR}しますか？(y/n) [y]" DEPEND_SRC
if [ "${DEPEND_SRC}" = "" ]; then
	DEPEND_SRC=y
fi


##### ダウンロード実行 #####
echo 
echo ダウンロード処理を開始します...
if [ "${CHECK_ANT}" = "y" ]; then
	ant -Dno=${CHECK_ANT_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${KICK_EXE}" = "y" ]; then
	ant -Dno=${KICK_EXE_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${KICK_SHELL}" = "y" ]; then
	ant -Dno=${KICK_SHELL_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${UNZIP_TEST}" = "y" ]; then
	ant -Dno=${UNZIP_TEST_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${REPLACE_TEST}" = "y" ]; then
	ant -Dno=${REPLACE_TEST_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${SELECT_CONFIG}" = "y" ]; then
	ant -Dno=${SELECT_CONFIG_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${DEPEND_DEST}" = "y" ]; then
	ant -Dno=${DEPEND_DEST_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${DEPEND_SRC}" = "y" ]; then
	ant -Dno=${DEPEND_SRC_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi


##### インストール実行 #####
INSTALLED_NO=
echo 
echo ${MODE_STR}処理を開始します...
if [ "${CHECK_ANT}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${CHECK_ANT_NO}
	ant -Dno=${CHECK_ANT_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${KICK_EXE}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${KICK_EXE_NO}
	ant -Dno=${KICK_EXE_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${KICK_SHELL}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${KICK_SHELL_NO}
	ant -Dno=${KICK_SHELL_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${UNZIP_TEST}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${UNZIP_TEST_NO}
	ant -Dno=${UNZIP_TEST_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${REPLACE_TEST}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${REPLACE_TEST_NO}
	ant -Dno=${REPLACE_TEST_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${SELECT_CONFIG}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${SELECT_CONFIG_NO}
	ant -Dno=${SELECT_CONFIG_NO} -Dsub=${SELECT_CONFIG_CONF} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${DEPEND_DEST}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${DEPEND_DEST_NO}
	ant -Dno=${DEPEND_DEST_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${DEPEND_SRC}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${DEPEND_SRC_NO}
	ant -Dno=${DEPEND_SRC_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi


##### インストール全体後処理 #####
echo 
ant -Dmode=${MODE} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install-after.xml"
if [ $? -ne 0 ]; then error_func; fi


##### 後処理 #####
end_func

}


##### 終了処理 #####
finally_func () {
	PATH=${_PATH}
	export PATH
	SCRIPTS_DIR=${_SCRIPTS_DIR}
	export SCRIPTS_DIR

	echo ${MODE_STR}処理を終了しました...
}


##### 正常終了 #####
end_func () {
	finally_func
	exit 0
}


##### 異常終了 #####
error_func () {
	echo ${MODE_STR}処理の途中で異常が発生しました...
	finally_func
	exit 1
}


##### 文字コード設定 #####
set_lang_func () {
	_OS_LANG=`echo ${LANG} | awk -F '.' '{print $2;}'`
	if [ "${_OS_LANG}" = "" ]; then
		echo 処理なし > /dev/nul
	else
		OS_LANG=${_OS_LANG}
	fi
}

main $*
