/**
 * RSSRCMConfig
 * [gRecǗVXepǗc[̃RtBOi[Rei
 */
package org.logical_paradox.rss.tools.rcm;

import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.robot.RSSNavigatorConfig;

public class RSSRCMConfig extends RSSConfig {
	private boolean cfgNavigationMode = true;
	private String cfgContentsConnStr = "";

	public RSSRCMConfig( String conf ) throws IOException, RSSIllegalConfigException {
		super( conf );
		String errmsg = checkResourceVariables();
		if( errmsg != null ) {
			throw new RSSIllegalConfigException( errmsg );
		}
	}

	/**
	 * ANZT
	 */
	public boolean getNavigationMode() {
		return cfgNavigationMode;
	}
	public String getContentsConnStr() {
		return cfgContentsConnStr;
	}

	/**
	 * p[^mF\bh
	 */
	protected String checkResourceVariables() {
		String errmsg = "";

		String m = getProperty( "NAVIGATION_MODE" );
		if( m == null || m.toUpperCase().trim().equals( "DISTRIB" ) ) {
			cfgNavigationMode = RSSNavigatorConfig.NAVIMODE_DISTRIB;
		} else if( m.toUpperCase().trim().equals( "STANDALONE" ) ) {
			cfgNavigationMode = RSSNavigatorConfig.NAVIMODE_STANDALONE;
		} else {
			errmsg += "NAVIGATION_MODEsł\n";
		}

		cfgContentsConnStr = getProperty( "CONTENTS_CONNSTR" );

		if( errmsg.trim().length() > 0 ) {
			return errmsg;
		}

		return null;
	}
}

// end of RSSRCMConfig.java
