/**
 * RoutingNodeClientImpl
 * oHm[h̃NCAgC^[tF[X()
 */
package org.logical_paradox.rss.router;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.util.RandomKeyGenerator;

public class RoutingNodeClientImpl extends UnicastRemoteObject implements RoutingNodeClient {
	private String robotKey = null;
	private RNodeClientFactoryImpl parent = null;

	/**
	 * RXgN^
	 */
	public RoutingNodeClientImpl( RNodeClientFactoryImpl p ) throws RemoteException {
		parent = p;
		robotKey = "SNODE:" + RandomKeyGenerator.getUniqKey();
	}

	/**
	 * ̃NCAgɌĂTm[ĥ̖Ԃ
	 */
	public String getNodeId() throws RemoteException {
		return robotKey;
	}

	/**
	 * ̃NCAg̐em[hID̖̂Ԃ
	 */
	public String getParentNodeId() throws RemoteException {
		return parent.getNodeId();
	}

	/**
	 * ̒Tm[hoHm[hnĂTbN̍A
	 * ̃\bh́CTm[hɂăNCAgC^[tF[X(RoutingNodeClient)ČĂяo
	 * 擾ꂽf[^́Cj
	 */
	public SyncCommand[] getSyncData() throws RemoteException {
		SyncCommand[] e = null;
		try {
			e = parent.getModifiedSyncData( robotKey );
		} catch( Exception se ) {
			se.printStackTrace();		// #####
			throw new RemoteException( se.getMessage() );
		}
		return e;
	}

	/**
	 * ̃m[h]ĂTbN̍Kp
	 * Tm[h̒TbŃC̃NCAgC^[tF[XǊ
	 * oHm[hNCAgɊi[Cł܂Ƃ߂ď
	 */
	public void sync( SyncCommand[] locks ) throws Exception {
		parent.sync( locks );
	}

	/*
	 * T̋ĂIPAhX͈̔
	 */
	public String[] getAllowedRoutingIPRanges() throws Exception {
		return parent.getAllowedRoutingIPRanges();
	}
}

// end of RoutingNodeClientImpl.java
