/*
 * $Id: RSSNavigatorConfig.java,v 1.3 2005/06/21 16:18:34 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.robot;

import java.io.IOException;

import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.dsync.RSSSyncConfig;
import org.logical_paradox.rss.router.algorithm.RoutingAlgorithm;

/**
 * RSSNavigatorConfig
 * RSS WebTirQ[^[̐ݒēNX̐ݒt@C
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class RSSNavigatorConfig extends RSSSyncConfig {
	public static final boolean NAVIMODE_DISTRIB = true;		// UVXeƂē삳
	public static final boolean NAVIMODE_STANDALONE = false;	// X^hA[œ삳

	/** ftHgUser-Agentl */
	private String cfgHttpUserAgent = "RSS-agent/1b (http://www.logical-paradox.org/)";
	/** TbNőۗL */
	private int cfgKeepLocks = 300;
	/** URLőۗL */
	private int cfgKeepUrls = 1600;
	/** URL]/ */
	private int cfgUnTracedURLSendCnt = 20;
	/** TURL */
	private int cfgDebugTraceURLs = 50;
	/** sOo̓XCb` */
	private boolean cfgNaviSwRunLog = false;
	/** sOt@C */
	private String cfgNavigatorRunLogFilename = "rssnavigator.run.log";
	/** 샂[h(standalone: P̓ / distrib: U) */
	private boolean cfgNavigationMode = true;
	/** TURL\/\ݒ */
	private boolean cfgEchoURL = true;
	/** TJnURL */
	private String cfgRoot = "";
	/** TCgbNL */
	private long cfgSiteLockExpire = 1000 * 60 * 5;
	/** oHASY */
	private RoutingAlgorithm cfgRoutingAlgorithm = null;
	/** xԊu */
	private int cfgNavigatorSyncInterval = 10000;
	/** ڑ敪UT[rXWXg */
	private String cfgDistServRegURL;

	/**
	 * RXgN^
	 * @param fn RtBOt@C
	 * @throws IOException RtBOt@C̓ǂݍ݂Ɏs
	 * @throws RSSIllegalConfigException RtBOt@C̓es
	 */
	public RSSNavigatorConfig(String fn) throws IOException, RSSIllegalConfigException {
		super(fn);
		String errmsg = checkResourceVariables();
		if(errmsg != null) {
			throw new RSSIllegalConfigException(errmsg);
		}
	}

	/**
	 * UT[rXWXgDSRURLԂ
	 * @return URL
	 */
	public String getDistServRegURL() {
		return cfgDistServRegURL;
	}
	/**
	 * TURL\/\ݒԂ
	 * @return true:\ / false:\
	 */
	public boolean getEchoURL() {
		return cfgEchoURL;
	}
	/**
	 * User-AgentԂ
	 * @return User-Agent
	 */
	public String getHttpUserAgent() {
		return cfgHttpUserAgent;
	}
	/**
	 * TURLԂ
	 * @return TURL(0:)
	 */
	public int getDebugTraceURLs() {
		return cfgDebugTraceURLs;
	}
	/**
	 * TbNőۗLԂ
	 * @return TbNőۗL
	 */
	public int getKeepLocks() {
		return cfgKeepLocks;
	}
	/**
	 * URLőۗLԂ
	 * @return URLőۗL
	 */
	public int getKeepUrls() {
		return cfgKeepUrls;
	}
	/**
	 * URL]/Ԃ
	 * @return URL]/
	 */
	public int getUnTracedURLSendCnt() {
		return cfgUnTracedURLSendCnt;
	}
	/**
	 * sOo̓XCb`Ԃ
	 * @return true:o͂ / false:o͂Ȃ
	 */
	public boolean getNaviSwRunLog() {
		return cfgNaviSwRunLog;
	}
	/**
	 * sOt@CԂ
	 * @return sOt@C
	 */
	public String getNavigatorRunLogFilename() {
		return cfgNavigatorRunLogFilename;
	}
	/**
	 * 샂[hԂ
	 * @return true:UVXe / false:standalone
	 */
	public boolean getNavigationMode() {
		return cfgNavigationMode;
	}
	/**
	 * TJnURLԂ
	 * @return TJnURL
	 */
	public String getRoot() {
		return cfgRoot;
	}
	/**
	 * TCgbNLԂ
	 * @return TCgbNL
	 */
	public long getSiteLockExpire() {
		return cfgSiteLockExpire;
	}
	/**
	 * oHASYԂ
	 * @return oHASY
	 */
	public RoutingAlgorithm getRoutingAlgorithm() {
		return cfgRoutingAlgorithm;
	}
	/**
	 * xԊuԂ
	 * @return xԊu
	 */
	public int getNavigatorSyncInterval() {
		return cfgNavigatorSyncInterval;
	}

	/**
	 * p[^mF\bh
	 * @return G[bZ[W
	 */
	protected String checkResourceVariables() {
		String errmsg = super.checkResourceVariables();			// f[cfg̃`FbN\bhĂяo

		if(getProperty("HTTP_USER_AGENT") != null) {
			cfgHttpUserAgent = getProperty("HTTP_USER_AGENT");
		}

		cfgDistServRegURL = getProperty("RSS_DSR");
		if(cfgDistServRegURL == null) {
			errmsg += "RSS_DSRw肳Ă܂\n";
		}

		try {
			cfgKeepLocks = getPropertyAsInt("KEEP_LOCKS");
		} catch(RSSValueFormatException vfe) {
			errmsg += "KEEP_LOCKS̒lsł\n";
		} catch(RSSNullValueException ne) {}

		try {
			cfgKeepUrls = getPropertyAsInt("KEEP_URLS");
		} catch(RSSValueFormatException vfe) {
			errmsg += "KEEP_URLS̒lsł\n";
		} catch(RSSNullValueException ne) {}

		try {
			cfgUnTracedURLSendCnt = getPropertyAsInt("UNTRACED_URL_SEND_CNT");
		} catch(RSSValueFormatException vfe) {
			errmsg += "UNTRACED_URL_SEND_CNT̒lsł\n";
		} catch(RSSNullValueException ne) {}

		try {
			cfgDebugTraceURLs = getPropertyAsInt("DEBUG_TRACE_URLS");
		} catch(RSSValueFormatException vfe) {
			errmsg += "DEBUG_TRACE_URLS̒lsł";
		} catch(RSSNullValueException ne) {}

		try {
			cfgNaviSwRunLog = getPropertyAsBool("NAVI_SW_RUNLOG");
		} catch(RSSValueFormatException vfe) {
			errmsg += "NAVI_SW_RUNLOG̒lsł";
		} catch(RSSNullValueException ne) {}

		try {
			cfgEchoURL = getPropertyAsBool("ECHO_URL");
		} catch(RSSValueFormatException vfe) {
			errmsg += "ECHO_URL̒lsł";
		} catch(RSSNullValueException ne) {}

		cfgNavigatorRunLogFilename = getProperty("NAVIGATOR_RUNLOG_FILENAME");
		String cfgSNavigationMode = getProperty("NAVIGATION_MODE");
		if(cfgSNavigationMode == null || cfgSNavigationMode.trim().toUpperCase().equals("DISTRIB")) {
			cfgNavigationMode = NAVIMODE_DISTRIB;
		} else if(cfgSNavigationMode.trim().toUpperCase().equals("STANDALONE")) {
			cfgNavigationMode = NAVIMODE_STANDALONE;
		} else {
			errmsg += "NAVIGATION_MODEsł";
		}

		cfgRoot = getProperty("ROOT");

		try {
			cfgSiteLockExpire = getPropertyAsInt("SITELOCK_EXPIRE");
			if(cfgSiteLockExpire < 0) {
				// bN̗L̓}CiXɐݒ肷邱Ƃ͂łȂ
				throw new RSSValueFormatException();
			}
		} catch(RSSValueFormatException vfe) {
			errmsg += "SITELOCK_EXPIRE0ȏɐݒ肵Ă\n";
		} catch(RSSNullValueException ne) {}

		try {
			cfgNavigatorSyncInterval = getPropertyAsInt("NAVIGATOR_SYNC_INTERVAL");
			if(cfgNavigatorSyncInterval < 500) {
				// ̃^C~O0.5bȉɐݒ肷邱Ƃ͂łȂ
				throw new RSSValueFormatException();
			}
		} catch(RSSValueFormatException vfe) {
			errmsg += "NAVIGATOR_SYNC_INTERVAL500ȏɐݒ肵Ă\n";
		} catch(RSSNullValueException ne) {}

		try {
			String algorithm = getProperty("ROUTING_ALGORITHM");
			cfgRoutingAlgorithm = (RoutingAlgorithm)Class.forName(algorithm).newInstance();
		} catch(Exception e) {
			errmsg += "ROUTING_ALGORITHMŒ`ꂽoHASÝC݂܂\n";
		}

		if(errmsg.trim().length() > 0) {
			return errmsg;
		} else {
			return null;
		}
	}
}

// end of RSSNavigatorConfig.java
