/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.rcm.accessor.simple;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeKey;

/**
 * RCMŎgpB-treeL[
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class RCMBtreeKey extends BtreeKey {
	// L[̃oCgTCY
	public static final int KEY_BYTE_SIZE = 32 + 8;		// eĂL[̒ + VRM̃ItZbg
	private String _key;
	private long _offset;

	/**
	 * RXgN^
	 * @param o L[ʕ
	 * @throws BtreeException L[̐Ɏs
	 */
	public RCMBtreeKey(Object o) throws BtreeException {
		super(o);
	}
	/**
	 * RXgN^
	 * @param bstream L[̃oCg\
	 * @throws BtreeException oCg񂩂L[IuWFNg̕Ɏs
	 */
	public RCMBtreeKey(byte[] bstream) throws BtreeException {
		super(bstream);
	}

	/**
	 * IuWFNgL[𕜌
	 * @param o IuWFNg
	 */
	protected void objectToBtreeKey(Object o) throws BtreeException {
		_key = ((String)o).trim();
	}

	/**
	 * oCg񂩂L[𕜌
	 * @param bstream L[̃oCg\
	 */
	protected void byteStreamToBtreeKey(byte[] bstream) throws BtreeException {
		ByteBuffer buffer = ByteBuffer.allocate(bstream.length).order(ByteOrder.BIG_ENDIAN);
		buffer.put(bstream);
		buffer.rewind();

		_offset = buffer.getLong();
		byte[] strbuf = new byte[bstream.length - 8];
		buffer.get(strbuf);
		_key = new String(strbuf).trim();
	}

	/**
	 * L[̕\Ԃ
	 * @return \ꂽL[
	 */
	public String toString() {
		return _key.toString();
	}

	/**
	 * L[̒lǂԂ
	 * @return true; / false:Ⴄ
	 */
	public boolean equals(Object obj) {
		if(obj instanceof String) {
			String s = (String)obj;
			return _key.equals(s.trim());
		} else if(obj instanceof BtreeKey) {
			String s = ((BtreeKey)obj).toString().trim();
			return _key.equals(s);
		} else {
			return false;
		}
	}

	/**
	 * w肳ꂽL[菬ǂԂ
	 * @param key rΏ
	 * @return boolean true: this < key / false: this >= key
	 */
	public boolean isLessThan( BtreeKey key ) {
		return _key.compareTo(key.toString().trim()) < 0;
	}

	/**
	 * w肳ꂽL[傫ǂԂ
	 * @param key rΏ
	 * @return boolean true: this > key / false: this <= key
	 */
	public boolean isGreaterThan( BtreeKey key ) {
		return _key.compareTo(key.toString().trim()) > 0;
	}

	/**
	 * L[̃oCg\Ԃ
	 * @return oCg
	 */
	public byte[] byteStream() {
		ByteBuffer buffer = ByteBuffer.allocate(KEY_BYTE_SIZE).order(ByteOrder.BIG_ENDIAN);
		buffer.putLong(_offset);
		buffer.put(_key.getBytes());
		
		return buffer.array();
	}

	/**
	 * VRM̃oCgψʂݒ肷
	 * @param offset oCgψ
	 */
	public void setOffset(long offset) {
		_offset = offset;
	}
	/**
	 * VRM̃oCgψʂԂ
	 * @return oCgψ
	 */
	public long getOffset() {
		return _offset;
	}
	/**
	 * ̃L[̃oCgTCYԂ
	 * @return oCgTCY
	 */
	public int byteSize() {
		return KEY_BYTE_SIZE;
	}
}
