/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RSSRCMConfig.java,v 1.3 2005/10/10 12:34:52 rampil Exp $
 */
package org.logical_paradox.rss.rcm;
import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

/**
 * RSSCMServConfig
 * RecǗVXepRtBO
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class RSSRCMConfig extends RSSConfig {
	/** Oo͐ݒ */
	private boolean cfgRCMSwRunLog = false;
	/** Ot@C */
	private String cfgRCMRunLogFilename = "rssrcm.run.log";
	/** [gRecǗVXe */
	private String cfgRSSContentsMngrService = "";
	/** ̃WXg */
	private int cfgInitialRegisterServices = 5;
	/** ̃Rect@C_[ */
	private int cfgInitialFinderServices = 10;
	/** s[N̍ő僌WXg */
	private int cfgMaxRegisterServices = 15;
	/** s[N̍őRect@C_[ */
	private int cfgMaxFinderServices = 20;
	/** RecWXg̐ړ */
	private String cfgRegisterServicePrefix = "";
	/** RecWXgƂɎgpo^G[WFg */
	private int cfgAgentsPerRegister = 2;
	/** RecWX^[L[̃TCY */
	private int cfgRegistQueueSize = 262144;
	/** RecMԊu(msec) */
	private int cfgContentsSendingInterval = 500;
	private int cfgContentsSendingScale = 20;
	/** RecANZT */
	private String cfgContentsAccessor = "";
	/** RecANZT̐ڑ */
	private String cfgContentsConnStr = "";
	/** DSR */
	private String cfgRSSDistributedServiceRegistry;

	/** RecL[ */
	private ContentsQueue q = null;


	/**
	 * RXgN^
	 * @param fn t@C
	 * @throws IOException RtBOt@C̓ǂݍ݂Ɏs
	 * @throws RSSIllegalConfigException sȃRtBOp[^o
	 */
	public RSSRCMConfig(String fn) throws IOException, RSSIllegalConfigException {
		super(fn);
		String errmsg = checkResourceVariables();
		if(errmsg != null) {
			throw new RSSIllegalConfigException(errmsg);
		}
	}
	/**
	 * Oo̓XCb`ԂD
	 * @return true:o͂ / false:o͂Ȃ
	 */
	public boolean getRCMSwRunLog() {
		return cfgRCMSwRunLog;
	}
	/**
	 * Ot@CԂD
	 * @return Ot@C
	 */
	public String getRCMRunLogFilename() {
		return cfgRCMRunLogFilename;
	}
	/**
	 * RecǗVXẽX^uԂD
	 * @return RecǗVXẽX^u
	 */
	public String getRSSContentsMngrService() {
		return cfgRSSContentsMngrService;
	}
	public int getInitialRegisterServices() {
		return cfgInitialRegisterServices;
	}
	public int getMaxRegisterServices() {
		return cfgMaxRegisterServices;
	}
	public int getMaxFinderServices() {
		return cfgMaxFinderServices;
	}
	public String getRegisterServicePrefix() {
		return cfgRegisterServicePrefix;
	}
	public int getAgentsPerRegister() {
		return cfgAgentsPerRegister;
	}
	public int getRegistQueueSize() {
		return cfgRegistQueueSize;
	}
	public int getContentsSendingInterval() {
		return cfgContentsSendingInterval;
	}
	public int getContentsSendingScale() {
		return cfgContentsSendingScale;
	}
	public String getContentsAccessor() {
		return cfgContentsAccessor;
	}
	public String getContentsConnStr() {
		return cfgContentsConnStr;
	}
	public String getRSSDistributedServiceRegistry() {
		return cfgRSSDistributedServiceRegistry;
	}
	public ContentsQueue getContentsQueue() {
		return q;
	}
	public int getInitialFinderServices() {
		return cfgInitialFinderServices;
	}

	/**
	 * p[^mF\bh
	 */
	protected String checkResourceVariables() {
		String errmsg = "";

		try {
			cfgRCMSwRunLog = getPropertyAsBool("RCM_SW_RUNLOG");
		} catch(RSSValueFormatException vfe) {
			errmsg += "RCM_SW_RUNLOGsł\n";
		} catch(RSSNullValueException ne) {}

		if(getProperty("RCM_RUNLOG_FILENAME") != null) {
			cfgRCMRunLogFilename = getProperty("RCM_RUNLOG_FILENAME");
		}
		cfgRSSContentsMngrService = getProperty("RSS_CONTENTS_MNGR_SERVICE");
		if(cfgRSSContentsMngrService == null) {
			errmsg += "RSS_CONTENTS_MNGR_SERVICEݒ肳Ă܂\n";
		}
		cfgRSSDistributedServiceRegistry = getProperty("RSS_DSR");
		if(cfgRSSDistributedServiceRegistry == null) {
			errmsg += "RSS_DSRݒ肳Ă܂\n";
		}

		try {
			cfgInitialRegisterServices = getPropertyAsInt("INITIAL_REGISTER_SERVICES");
		} catch(RSSValueFormatException vfe) {
			errmsg += "INITIAL_REGISTER_SERVICESsł\n";
		} catch(RSSNullValueException ne) {}
		try {
			cfgInitialFinderServices = getPropertyAsInt("INITIAL_FINDER_SERVICES");
		} catch(RSSValueFormatException vfe) {
			errmsg += "INITIAL_FINDER_SERVICESsł\n";
		} catch(RSSNullValueException ne) {}
		try {
			cfgMaxRegisterServices = getPropertyAsInt("MAX_REGISTER_SERVICES");
		} catch(RSSValueFormatException vfe) {
			errmsg += "MAX_REGISTER_SERVICESsł\n";
		} catch(RSSNullValueException ne) {}
		try {
			cfgMaxFinderServices = getPropertyAsInt("MAX_FINDER_SERVICES");
		} catch(RSSValueFormatException vfe) {
			errmsg += "MAX_FINDER_SERVICESsł\n";
		} catch(RSSNullValueException ne) {}

		cfgRegisterServicePrefix = getProperty("REGISTER_SERVICE_PREFIX");
		if(cfgRegisterServicePrefix == null) {
			errmsg += "REGISTER_SERVICE_PREFIXݒ肳Ă܂\n";
		}
		try {
			cfgAgentsPerRegister = getPropertyAsInt("AGENTS_PER_REGISTER");
		} catch(RSSValueFormatException vfe) {
			errmsg += "AGENTS_PER_REGISTERsł\n";
		} catch(RSSNullValueException ne) {}
		try {
			cfgRegistQueueSize = getPropertyAsInt("REGIST_QUEUE_SIZE");
		} catch(RSSValueFormatException vfe) {
			errmsg += "REGIST_QUEUE_SIZEsł\n";
		} catch(RSSNullValueException ne) {}
		try {
			cfgContentsSendingInterval = getPropertyAsInt("CONTENTS_SENDING_INTERVAL");
		} catch(RSSValueFormatException vfe) {
			errmsg += "CONTENTS_SENDING_INTERVALsł\n";
		} catch(RSSNullValueException ne) {}
		try {
			cfgContentsSendingScale = getPropertyAsInt("CONTENTS_SENDING_SCALE");
		} catch(RSSValueFormatException vfe) {
			errmsg += "CONTENTS_SENDING_SCALEsł\n";
		} catch(RSSNullValueException ne) {}

		cfgContentsAccessor = getProperty("CONTENTS_ACCESSOR");
		if(cfgContentsAccessor == null) {
			errmsg += "CONTENTS_ACCESSORݒ肳Ă܂\n";
		}
		if(getProperty("CONTENTS_CONNSTR") != null) {
			cfgContentsConnStr = getProperty("CONTENTS_CONNSTR");
		}

		if(errmsg.trim().length() > 0) {
			return errmsg;
		}

		// RecL[ĂȂȂ΁CŐ
		if(getRegistQueueSize() > 0) {
			q = new ContentsQueue(getRegistQueueSize());
		}
		return null;
	}
}

// end of RSRCMConfig.java
