/**
 * RSSContentsMngrServiceImpl
 * RSS/1b RecǗVXe̎
 */
package org.logical_paradox.rss.rcm;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.cli.Argument;
import org.logical_paradox.common.cli.ArgumentParser;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory;

public class RSSContentsMngrServiceImpl extends UnicastRemoteObject implements RSSContentsMngrService,RSSSubModule {
	/** K[ */
	private static final Log log = LogFactory.getLog(RSSContentsMngrServiceImpl.class);

	public static String RCM_CONF_FILENAME = "../conf/rssrcm.conf";	// Ot@C

	private String rcmServiceName = null;							// ̃T[rX̖

	private RSSRCMConfig cfg = null;								// RtBO
	private int registerServiceCnt = 1;							// o^WX^T[rX̒ʔ
	private int finderServiceCnt = 1;								// o^t@C_[T[rX̒ʔ
	private ContentsAccessorFactory accessorFactory = null;		// RecANZT̐q
	private ArrayList registers = null;								// RecWX^T[rX(L[:T[rX/l:)
	private ArrayList finders = null;								// Rect@C_[T[rX

	private int registerIdx = 0;									// ɕԂׂWX^T[rX̒ʂԍ
	private int finderIdx = 0;									// ̕Ԃׂt@C_[T[rX̒ʂԍ

	/** RtBOt@C */
	private String rcmConfigFilename = RCM_CONF_FILENAME;

	/**
	 * RXgN^D
	 * @throws RemoteException CX^XɎs
	 */
	public RSSContentsMngrServiceImpl() throws RemoteException {
	}
	/**
	 * RXgN^D
	 * @param filename RtBOt@C
	 * @throws RemoteException CX^XɎs
	 */
	public RSSContentsMngrServiceImpl(String filename) throws RemoteException {
		rcmConfigFilename = filename;
	}

	/**
	 * YT[rX
	 */
	protected void init() throws Exception {
		registers = new ArrayList();
		finders = new ArrayList();

		log.info("OC^[܂");

		// RecANZT̃t@Ng𐶐Ă
		accessorFactory = new ContentsAccessorFactory(cfg.getContentsAccessor(), cfg.getContentsConnStr());
		accessorFactory.setRCMServiceName(getFqsn());

		log.info("[gRecǗVXe\Ă܂");

		// ݒ肳ꂽ̃WX^T[rXOɍ쐬āCRMIWXgɓo^Ă
		for(int i = 0; i < cfg.getInitialRegisterServices(); i++) {
			createRegister();
		}
		// ݒ肳ꂽ̃t@C_[T[rXOɍ쐬Ă
		for(int j = 0; j < cfg.getInitialFinderServices(); j++) {
			createFinder();
		}
	}

	/**
	 * RecNCAgǉ
	 */
	protected void createFinder() throws Exception {
		synchronized(finders) {
			String serviceName = "FINDER_" + (finders.size() + 1);
			finders.add(new ContentsFinderImpl(serviceName, accessorFactory.getAccessor()));

			log.info("t@C_[[" + serviceName + "]ǉ܂");
			finderServiceCnt++;
		}
	}

	/**
	 * VReco^T[rXǉ
	 * WX^T[rX̃NX́CKX^uexportł^CvłȂ΂ȂȂ
	 * ɗRȂꍇCRCMContentsRegisterImplgp邱
	 */
	protected void createRegister() throws Exception {
		String serviceName = cfg.getRegisterServicePrefix() + registerServiceCnt;
		RCMContentsRegister r = new RCMContentsRegisterImpl(serviceName, cfg, accessorFactory.getAccessor());
		registers.add(r);

		Naming.rebind(serviceName, r);

		log.info("WX^T[rX[" + serviceName + "]ǉ܂");
		registerServiceCnt++;
	}

	/**
	 * o^ĂReco^T[rXXg
	 */
	public String[] getRegisterNames() throws RemoteException {
		return null;
	}

	/**
	 * svɂȂReco^T[rX폜
	 */
	public void gc() throws RemoteException {
	}
	/**
	 * RecT[rX̃C^[tF[X擾
	 */
	public ContentsFinder getFinder() throws RemoteException {
		if(finderIdx >= finders.size()) {
			finderIdx = 0;
		}
		ContentsFinder finder = (ContentsFinder)finders.get(finderIdx++);
		log.info("t@C_[T[rX[" + finder.getName() + "I܂");
		return finder;
	}
	/**
	 * Reco^T[rX̃C^[tF[X擾
	 */
	public ContentsRegister getRegister() throws RemoteException {
		if(registerIdx >= registers.size()) {
			registerIdx = 0;
		}

		ContentsRegister r = (ContentsRegister)registers.get(registerIdx++);
		log.info("WX^T[rX[" + r.getRegisterName() + "]I܂");
		return r;
	}

	/**
	 * T[rXo^p\bh
	 */
	public static void main(String[] args) throws Exception {
		String filename = null;
		Argument[] arguments = ArgumentParser.parse(args);
		for(int i = 0; i < arguments.length; i++) {
			Argument arg = arguments[i];
			if(arg.isOption()) {
				if("config".equals(arg.getName())) {
					filename = arg.getValue();
				}
			}
		}
		// RecǗVXẽCX^X𐶐
		RSSContentsMngrServiceImpl server = null;
		if(filename == null) {
			server = new RSSContentsMngrServiceImpl();
		} else {
		}

		server.startModule();
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[Jn
	 */
	public void startModule() throws ModuleException {
		try {
			cfg = new RSSRCMConfig(RCM_CONF_FILENAME);
			// RecǗVXe[gT[rXIT[o[֓o^
			// o^C̃T[rX̖OՂD
			rcmServiceName = LookupFactory.getLookup(cfg.getRSSDistributedServiceRegistry()).bind(RSSDistributedServiceRegistry.RSS_SERVID_REMOTE_CONTENTS_MGR, this);
			init();
		} catch(Exception e) {
			throw new ModuleException(e);
		}

		log.info("[gRecǗVXeJn܂");
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[ꎞ~
	 */
	public void suspendModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * ~Ă郂W[̎sĊJ
	 */
	public void continueModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[~
 	 * ̃\bhĂ΂ꂽꍇCW[͈Sȕ@ŏI
	 * IW[́CVCX^XȂƊJn邱Ƃ͂łȂ
	 */
	public void stopModule() throws ModuleException {
	}

	/**
	 * T[rXԂ
	 * @return T[rX
	 * @throws RemoteException T[rX擾Ɏs
	 */
	public String getName() throws RemoteException {
		return rcmServiceName;
	}
	/**
	 * SCT[rXԂ
	 * @return SCT[rX
	 * @throws RemoteException T[rX擾Ɏs
	 */
	public String getFqsn() throws RemoteException {
		return rcmServiceName + "@" + cfg.getRSSDistributedServiceRegistry();
	}
	/**
	 * T[rX~
	 * RMIT[o[ƂĎĂꍇCunexport
	 * @param force true:~ / false:Sɒ~
	 * @throws RemoteException T[rX~Ɏs
	 */
	public void shutdown(boolean force) throws RemoteException {
		log.info("T[o[~܂");

		log.info("Reco^T[rX~Ă܂");
		synchronized(registers) {
			for(Iterator it = registers.iterator(); it.hasNext();) {
				ContentsRegister cr = (ContentsRegister)it.next();
				cr.shutdown();
				if(cr instanceof RCMContentsRegister) {
					UnicastRemoteObject.unexportObject((RCMContentsRegister)cr, force);
				}
			}
			registers.clear();
		}
		log.info("RecT[rX~Ă܂");
		synchronized(finders) {
			for(Iterator it = finders.iterator(); it.hasNext();) {
				ContentsFinder cf = (ContentsFinder)it.next();
				UnicastRemoteObject.unexportObject(cf, force);
			}
			finders.clear();
		}

		// DSR؂藣
		try {
			log.info("[gRecǗVXeDSR؂藣Ă܂");
			LookupFactory.getLookup(cfg.getRSSDistributedServiceRegistry()).unbind(RSSDistributedServiceRegistry.RSS_SERVID_REMOTE_CONTENTS_MGR, rcmServiceName);
		} catch (Exception e1) {
			throw new RemoteException(e1.getMessage());
		}


		UnicastRemoteObject.unexportObject(this, force);

		log.info("T[o[~܂");
	}
}

// end of RSSContentsMngrServiceImpl.java
