/**
 * Reco^sȂG[WFg
 * ̃NX̓XbhƂē삷
 */
package org.logical_paradox.rss.rcm;

import org.logical_paradox.rss.lcmgr.LocalContents;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;

public class ContentsStoreAgent extends Thread {
	private ContentsAccessor accessor = null;
	private RSSRCMConfig cfg = null;
	private ContentsQueue queue = null;

	/**
	 * RXgN^
	 */
	public ContentsStoreAgent(ContentsAccessor a, RSSRCMConfig conf) throws IllegalArgumentException {
		if(a == null || conf == null) {
			throw new IllegalArgumentException("ContentsStoreAgenẗnull");
		}

		accessor = a;
		cfg = conf;
		queue = cfg.getContentsQueue();

		setDaemon(true);
	}

	/**
	 * XbhƂē삷镔
 	 */
	public void run() {
		try {
			while(true) {
				Thread.sleep(cfg.getContentsSendingInterval());
				store(cfg.getContentsSendingScale());
			}
		} catch(InterruptedException ie) {
			// I
		}
	}

	/**
	 * Reco^
	 * o^RećCRecL[擾
	 */
	protected void store(int numberOfContents) {
		while(numberOfContents > 0) {
			numberOfContents--;

			LocalContents lc = queue.dequeue();
			if(lc == null) {
				// RecL[ɑSRReci[ĂȂ̂ŏI
				break;
			}

			// o^
			accessor.regist(lc.getURL(), lc.getContents());
		}
	}

	/**
	 * I
	 */
	public void done() {
		this.interrupt();
	}
}

// end of ContentsStoreAgent.java
