/**
 * ContentsQueue
 * ContentsStoreAgenti[Ώۂ̃RecL邽߂̃NX
 * RecWX^T[rX1ɑ΂āC1
 */
package org.logical_paradox.rss.rcm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.lcmgr.LocalContents;

public class ContentsQueue {
	/** K[ */
	private static final Log log = LogFactory.getLog(ContentsQueue.class);

	protected LocalContents[] queue = null;			// Reci[L[
	protected int topIdx = 0;						// ݂̎o擪ʒu
	protected int lastIdx = 0;						// ݂̏ݍŌ

	/**
	 * RXgN^
	 */
	public ContentsQueue( int qsize ) throws IllegalArgumentException {
		if( qsize < 1 ) {
			throw new IllegalArgumentException( "sȃTCY:" + qsize );
		}
		queue = new LocalContents[ qsize ];
		topIdx = lastIdx = 0;

		// RecL[̏
		for( int i = 0; i < qsize; i++ ) {
			queue[i] = null;
		}
	}

	/**
	 * GL[
	 * L[Ɋi[łꍇtrueCsꍇfalseԂ
	 */
	public boolean enqueue( LocalContents lc ) {
		if( queue[ lastIdx ] != null ) {
			return false;
		}

		queue[ lastIdx++ ] = lc;
		if( lastIdx == queue.length ) {
			lastIdx = 0;
		}

		log.info( "GL[:" + lc.getURL() );
		return true;
	}

	/**
	 * fL[
	 * oɎsꍇnullԂ
	 */
	public LocalContents dequeue() {
		if( queue[ topIdx ] == null || topIdx == lastIdx ) {
			return null;
		}

		LocalContents lc = queue[ topIdx ];
		queue[ topIdx ] = null;
		topIdx++;

		if( topIdx == queue.length ) {
			topIdx = 0;
		}

		log.info( "fL[:" + lc.getURL() );
		return lc;
	}
}

// end of ContentsQueue.java
