/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RMILookup.java,v 1.9 2005/10/12 16:39:05 rampil Exp $
 */
package org.logical_paradox.rss.lookup.impl;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;

import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.Lookup;

/**
 * RMIŎꂽAU\[Xlbg[NT[rX
 * T[rX̊ǗrmiregistrygpD
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.9 $
 */
public class RMILookup implements Lookup {
	/** oCh^[Qbg */
	private String bindTarget;
	/** UT[rXWXg */
	private RSSDistributedServiceRegistry dsr;

	/**
	 * RXgN^
	 * @param bt oCh^[Qbg(̎̏ꍇdsruri)
	 */
	public RMILookup(String bt) throws MalformedURLException, RemoteException, NotBoundException {
		// UT[rXWXg[h
		dsr = (RSSDistributedServiceRegistry)Naming.lookup(bt);
		bindTarget = bt;
	}
	/**
	 * RXgN^
	 * @throws Exception ȂO
	 */
	public RMILookup() throws Exception {
	}
	/**
	 * UT[rXoCh܂D
	 * oCh́CL敪U\[Xlbg[N肵܂D
	 * @return ۂɃoChꂽۂ̎ʕ
	 * @throws Exception oChɎs
	 */
	public String bind(int type, Object o) throws Exception {
		Service r = (Service)o;

		// UT[rXWXgɑ΂āCVT[rXo^
		String node = dsr.bind(type, r);
		// RMIWXgɃT[o[o^
		Naming.rebind(node, r);

		return node;
	}
	/**
	 * UT[rXAoCh܂D
	 * @param type T[rX̃^Cv
	 * @param name o^m[h
	 * @throws Exception AoChɎs
	 */
	public void unbind(int type, String name) throws Exception {
		dsr.unbind(type, name);
		Naming.unbind(name);
	}
	/**
	 * DSRWXgɓo^
	 * @param stub DSR̃CX^X
	 * @throws Exception o^Ɏs
	 */
	public void register(RSSDistributedServiceRegistry stub) throws Exception {
		Naming.rebind(stub.getName(), stub);
		dsr = stub;
	}
	/**
	 * L敪U\[Xlbg[NC̎ނ̃T[rX𔭌܂D
	 * @param name T[rX̎
	 * @return ꂽT[rX̃X^u
	 * @throws Exception Ɏs
	 */
	public Object lookup(int type) throws Exception {
		// DSRɖ₢킹
		return dsr.getService(type);
	}
	/**
	 * wm[hID̃T[rXԂ܂D
	 * @param nodeId m[hID
	 * @return T[rX̃X^v
	 * @throws Exception bNAbvɎs
	 */
	public Service lookup(String nodeId) throws Exception {
		if(dsr.getName().equals(nodeId)) {
			return dsr;
		} else {
			return dsr.getService(nodeId);
		}
	}
	/**
	 * ̔T[rX̃oCh^[Qbg(ڑm[h)Ԃ
	 * @return oCh^[Qbg
	 */
	public String getBindTargetName() {
		return bindTarget;
	}
	/**
	 * T[rX̃Xg擾
	 * @param type T[rX̃^Cv
	 * @return T[rX̔z
	 * @throws Exception ꗗɎsۂɔO
	 */
	public String[] services(int type) throws Exception {
		return dsr.services(type);
	}
	/**
	 * ̔T[rX̃oCh^[Qbgɑ΂āA[eBOe[u̍XVw
	 * @throws Exception XVɔO
	 */
	public void configure() throws Exception {
		dsr.configure();
	}
	/**
	 * [gQƂ݂ɋL
	 * @param stub o^Ă炤X^u
	 * @throws RemoteException o^Ɏs
	 */
	public Remote hug(Service stub) throws RemoteException {
		dsr.bind(RSSDistributedServiceRegistry.RSS_SERVID_SERVICE_LOCATER, stub);
		return dsr;
	}
	/**
	 * [gQƂ݂ɋL
	 * o^𖾎IɎwł
	 * @param stub o^Ă炤X^u
	 * @param name T[rX
	 * @return RemoteException o^Ɏs
	 */
	public Remote hug(String name, Service stub) throws RemoteException {
		dsr.bind(RSSDistributedServiceRegistry.RSS_SERVID_SERVICE_LOCATER, name, stub);
		return dsr;
	}
}
