/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: StandAloneContentsRegister.java,v 1.3 2005/10/17 15:12:34 rampil Exp $
 */
package org.logical_paradox.rss.lcmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.rcm.ContentsRegister;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory;
import org.logical_paradox.rss.util.RandomKeyGenerator;

/**
 * StandAloneContentsRegister
 * X^hA[ł̃Reco^NCAgIuWFNgD
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class StandAloneContentsRegister implements ContentsRegister {
	/** K[ */
	private static final Log log = LogFactory.getLog(StandAloneContentsRegister.class);
	/** Reci[ĂXg[WɃANZX邽߂̃C^[tF[X */
	private ContentsAccessor accessor = null;
	/** ̃C^[tF[XLǂ */
	private boolean activeFlag = false;
	/** RecWX^ */
	private final String rkey;

	/**
	 * RXgN^D
	 * @param config [JRecǗVXẽRtBO[V
	 * @param connstr ڑ
	 */
	public StandAloneContentsRegister(RSSLCConfig config) {
		try {
			ContentsAccessorFactory factory = new ContentsAccessorFactory(config.getContentsAccessor(), config.getContentsConnStr());
			accessor = factory.getAccessor();
			activeFlag = true;
		} catch(Exception e) {
			activeFlag = false;
			log.error("RecANZX̂߂̃C^[tF[X擾ł܂ł");
		} finally {
			rkey = "localreg_" + RandomKeyGenerator.getUniqKey();
		}
	}

	/**
	 * RecWX^ԂD
	 * @return RecWX^
	 */
	public String getRegisterName() {
		return rkey;
	}
	/**
	 * Reco^D
	 * @param url URL
	 * @param contents Rec
	 */
	public void registContents(String url, String contents) {
		if(url == null || url.trim().length() == 0 || contents == null || contents.trim().length() == 0) {
			return;
		}
		if(isActive() == false) {
			return;
		}
		try {
			accessor.regist(url, contents);
		} catch(Exception e) {
		}
	}

	/**
	 * Reco^Ă邩ǂԂD
	 * @param url URL
	 * @return true:o^Ă / false:o^ĂȂ
	 */
	public boolean isRegistered(String url) {
		if(isActive() == false) {
			return false;
		}
		try {
			return accessor.find(url) != null ? true : false;
		} catch(Exception e) {
			return false;
		}
	}

	/**
	 * Rec̓o^D
	 * @param url o^URL
	 */
	public void unregistContents(String url) {
		if(isActive() == false) {
			return;
		}
		try {
			accessor.unregist(url);
		} catch(Exception e) {
		}
	}

	/**
	 * o^ĂSẴRec폜D
	 */
	public void unregistAll() {
		if(isActive() == false) {
			return;
		}
		try {
			accessor.unregistAll();
		} catch(Exception e) {
		}
	}

	/**
	 * ̃WX^I/FLǂԂ
	 * @return true:L / false:
	 */
	private boolean isActive() {
		return activeFlag;
	}
	/**
	 * Reco^NCAg~D
	 * @throws RemoteException ~Ɏs
	 */
	public void shutdown() {
		accessor.close();
	}
}
