/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RSSLocalContentsMgr.java,v 1.5 2005/12/27 16:55:10 rampil Exp $
 */
package org.logical_paradox.rss.lcmgr;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.http.WebContents;

/**
 * RSSLocalContentsMgr
 * Recf[^[JɕۑC[g̃RecǗVXe֓]肷IuWFNg<br>
 * XbhƂē삷D
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class RSSLocalContentsMgr {
	/** K[ */
	private static final Log log = LogFactory.getLog(RSSLocalContentsMgr.class);
	public static final String RSSLCMGR_CONF_FILENAME = "../conf/rsslcmgr.conf";

	public static final int MAX_MEMCACHE_SIZE = 10485760;	// ɔzuĂRec̍őTCY(ftHg=10MB)
	public static final int MAX_FILECACHE_SIZE = 1024;		// ̐胍[JLbVt@CȂꍇ͒Tꎞ~
	public static final int RESTORE_CNT_FROM_LCACHE = 64;	// xɃɎ荞ރLbVt@C

	protected RSSLCConfig lcfg = null;						// [JRecǗVXe̐ݒf[^
	private RSSLCAgent[] agnts = null;						// Rec]p̃G[WFg

	/**
	 * ftHgRXgN^
	 */
	public RSSLocalContentsMgr(boolean navimode) throws RSSIllegalConfigException {
		log.info("[JRecǗVXeĂ܂");

		try {
			// [JRecǗVXẽRtBOpf[^𐶐
			lcfg = new RSSLCConfig(RSSLCMGR_CONF_FILENAME);

		} catch(IOException ioe) {
			log.error("[JRecǗVXepK[̍쐬Ɏs܂");
			throw new RSSIllegalConfigException(ioe.getMessage());
		}

		try {
			lcfg.cr = ContentsRegisterFactory.getContentsRegister(lcfg, navimode);
		} catch(Exception ie) {
			log.error("WebRecT[o[烌WX^I/F󂯎܂ł");
			throw new RSSIllegalConfigException(ie.getMessage());
		}
		// G[WFg쐬
		int agents = lcfg.getContentsSendingMgrs();
		agnts = new RSSLCAgent[ agents ];
		for(int i = 0; i < agents; i++) {
			agnts[i] = new RSSLCAgent(lcfg, this);
		}

		log.info("[JRecǗVXéC" + agnts.length + "̃G[WFg쐬܂");
		log.info("[JRecǗVXe܂");
	}

	/**
	 * Rec]G[WFgJn
	 */
	public void start() {
		for(int i = 0; i < agnts.length; i++) {
			agnts[i].start();
		}
		log.info("SẴG[WFgJn܂");
	}

	/**
	 * XbhI
	 * XbhIꍇCM̃RecSă[g̃VXe֓]
	 */
	public void done() {
		try {
			for(int i = 0; i < agnts.length; i++) {
				agnts[i].done();
				agnts[i].join();			// Xbh~̑҂킹
			}
		} catch(InterruptedException ie) {}

		log.info("SẴG[WFg~܂");

	}

	/**
	 * Rec[J̃t@CVXeɕۊǂ
	 */
	public void store(WebContents c) throws IOException, IllegalObjectStateException {
		synchronized(lcfg.memCache) {
			int newId = lcfg.nextno;
			lcfg.nextno++;

			if(c.getWebContents().length() > MAX_MEMCACHE_SIZE) {

				// i[悤ƂĂRec̃TCYCLbṼTCY傫ꍇ
				// Ɏ荞ނƂłȂ̂ŁC[jOo͂Ĕj
				log.info(
						"'" + c.getURL().toString() + "'́C" +
						"LbVTCY傫߁Cꂸɔj܂D" +
						"Pɂ̓LbṼTCYgĂ"
				);

				System.err.println("lcmgr: LbV傫");
				// I
				return;

			} else if(lcfg.memCacheSize + c.getWebContents().length() >= MAX_MEMCACHE_SIZE) {

				// Ɋi[łTCY𒴂ꍇ̓t@C֏o
				// IDt@CɂāCRect@C𐶐
				String filenameFullPath = lcfg.getContentsCacheDir() + File.separator + Integer.toString(newId);
				PrintWriter w = new PrintWriter(new FileWriter(new File(filenameFullPath)));

				// Reco͂
				// URL̑̏ɂẮCI(fileEntries)ŊǗ
				lcfg.fileEntries.add(new CacheFileEntry(new LocalContents(c.getURL().toString(), c.getWebContents()), filenameFullPath));
				w.print(c.getWebContents());
				w.flush();
				w.close();

				log.trace("Rect@CɊi[܂");

			} else {

				// Ɋi[łꍇ́Ct@C֏oɃɎc
				lcfg.memCache.add(new LocalContents(c.getURL().toString(), c.getWebContents()));
				lcfg.memCacheSize += c.getWebContents().length();

				log.trace("RecɊi[܂");

			}
		}

		log.trace("Reci[܂:" + c.getURL().toString() + "(" + c.getWebContents().length() + ")");
		log.trace("c胁e:" + (MAX_MEMCACHE_SIZE-lcfg.memCacheSize) + "bytes");

		// i[ƓɁCLbVt@CȂǂmF
		// ꍇ͒T~Kv邽
		synchronized(lcfg.fileEntries) {
			if(lcfg.runningStatus == true && lcfg.fileEntries.size() >= MAX_FILECACHE_SIZE) {
				// w萔ȏɃLbVt@CĂ܂Ăꍇ
				// S]悤ɐݒ肵āCTꎞIɒ~
				lcfg.runningStatus = false;
				log.info(" LbVtbV܂ŁCT~܂ ");
			}
		}
	}

	/**
	 * VRec󂯕t邱Ƃł邩
	 * ܂ɂ̃[JLbVt@C݂ĂāC]ǂȂꍇ
	 * ̃tOfalseɂȂDfalseɂȂĂԂ́CRSSWebNavigator͓]~({bgT~)
	 */
	public boolean isReceivable() {
		return lcfg.runningStatus;
	}
}

// end of RSSLocalContentsMgr.java
