/**
 * ContentsRegisterFactory
 * Reco^NCAg
 * ɂāCWebRecT[o[Ƃ̒^CvƁCX^hA[̃^Cv𐶐
 */
package org.logical_paradox.rss.lcmgr;

import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.rcm.ContentsRegister;
import org.logical_paradox.rss.rcm.RSSContentsMngrService;
import org.logical_paradox.rss.robot.RSSNavigatorConfig;

public final class ContentsRegisterFactory {
	/**
	 * RXgN^
	 */
	private ContentsRegisterFactory() {
	}

	/**
	 * Reco^NCAg̃CX^X𐶐D
	 * ̃\bh̓ftHg^CṽReco^NCAg𐶐
	 * @param config [JRecǗVXẽRtBO
	 * @return ꂽReco^NCAg
	 */
	public static final ContentsRegister getContentsRegister(RSSLCConfig config) {
		try {
			return getContentsRegister(config, RSSNavigatorConfig.NAVIMODE_DISTRIB);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * Reco^NCAg̃CX^X𐶐D
	 * ̃\bh͔Cӂ̃^CṽNCAgIuWFNg쐬
	 * @param config [JRecǗVXẽRtBO
	 * @param ctype 샂[h
	 * @return ꂽReco^NCAg
	 */
	public static final ContentsRegister getContentsRegister(RSSLCConfig config, boolean ctype) throws Exception {
		if(ctype == RSSNavigatorConfig.NAVIMODE_DISTRIB) {
			// WebRecT[o[Ƃ̒sȂNCAg
			return createRemoteContentsRegister(config);
		} else if(ctype == RSSNavigatorConfig.NAVIMODE_STANDALONE) {
			// X^hA[̏ꍇ
			return new StandAloneContentsRegister(config);
		} else {
			// ꍇ̓IuWFNg𐶐ȂŗO𓊂
			throw new IllegalArgumentException();
		}
	}
	/**
	 * [gRecǗVXeReco^NCAg擾ĕԂD
	 * @param config [JRecǗVXẽRtBO
	 * @return ꂽReco^NCAg
	 */
	public static ContentsRegister createRemoteContentsRegister(RSSLCConfig config) throws Exception {
		int serviceType = RSSDistributedServiceRegistry.RSS_SERVID_REMOTE_CONTENTS_MGR;
		RSSContentsMngrService rcm = (RSSContentsMngrService)LookupFactory.getLookup(config.getContentsConnStr()).lookup(serviceType);

		return rcm.getRegister();
	}
}

// end of ContentsRegisterFactory.java
