/**
 * URLPool
 * TURLi[ĂIuWFNg
 */
package org.logical_paradox.rss.http;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;


public class URLPool {
	private Hashtable domain = null;		// hCǗe[u


	/**
	 * ftHgRXgN^
	 */
	public URLPool() {
		domain = new Hashtable();
	}

	/**
	 * URLǉ
	 */
	public void add( String url ) throws MalformedURLException {
		// URLhC̕𒊏o
		String dn = getDomainName( url );
		if( dn == null || dn.trim().length() == 0 ) {
			throw new MalformedURLException();
		}

		// YhCURLZbg擾
		HashSet s = (HashSet)domain.get( dn );
		if( s == null ) {
			s = new HashSet();
			domain.put( dn, s );
		}

		// URLǉ
		// HashSetȂ̂ŏd͏㏑D]Ĕ͕KvȂ
		s.add( url );

		synchronized( domain ) {
			domain.notifyAll();
		}
	}

	/**
	 * URL܂Ƃ߂Ēǉ
	 */
	public void add( String[] urls ) throws MalformedURLException {
		for( int i = 0; i < urls.length; i++ ) {
			if( urls[i] != null ) {
				add( urls[i] );
			}
		}

		synchronized( domain ) {
			domain.notifyAll();
		}
	}

	/**
	 * URL܂Ƃ߂Ēǉ
	 */
	public void add( Iterator i ) throws MalformedURLException {
		while( i.hasNext() ) {
			add( (String)i.next() );
		}
		synchronized( domain ) {
			domain.notifyAll();
		}
	}

	/**
	 * w͈͂̃hCԂ
	 */
	public String[] domains( int idx, int len ) {
		String[] d = domains();
		Vector p = new Vector();

		// w͈͂̃hCtFb`
		for( int i = 0; i < len && i < d.length; i++ ) {
			p.addElement( d[i] );
		}

		// ̔zɂĕԂ
		return (String[])p.toArray( new String[0] );
	}

	/**
	 * hCꗗԂ
	 */
	public String[] domains() {
		Set keys = null;
		synchronized( domain ) {
			keys = domain.keySet();
		}

		if( keys == null ) {
			return null;
		}
		return (String[])keys.toArray( new String[0] );
	}

	/**
	 * whCURLԂ
	 * whCURL݂ȂꍇnullԂ
	 */
	public String[] urls( String dn ) {
		HashSet set = (HashSet)domain.get( dn );
		if( set == null ) {
			return null;
		}

		return (String[])set.toArray( new String[0] );
	}

	/**
	 * whC̃Ce[^Ԃ
	 * whCURL݂ȂꍇnullԂ
	 */
	public Iterator getURLIterator( String dn ) {
		HashSet set = (HashSet)domain.get( dn );
		if( set == null ) {
			return null;
		}

		return set.iterator();
	}

	/**
	 * URLhC̕擾
	 * ̏ꍇC|[gԍvgR͊֌WȂ̂Ƃ
	 * TuhC͊֌ŴƂ(ʂ̃T[o[ł\邽)
	 */
	protected String getDomainName( String url ) throws MalformedURLException {
		URL u = new URL( url );
		String siteName = new String( u.getHost() );

		return siteName;
	}

	/**
	 * wURLv[폜
	 */
	public void remove( String url ) throws MalformedURLException {
		String dn = getDomainName( url );
		if( dn == null || dn.trim().length() == 0 ) {
			throw new MalformedURLException();
		}

		HashSet set = (HashSet)domain.get( dn );
		if( set == null ) {
			return;
		}

		// 폜
		set.remove( url );

		if( set.size() == 0 ) {
			// URL1ۗLȂhCɂȂĂ܂ꍇ
			// ̃hC폜
			domain.remove( dn );
		}
	}

	/**
	 * whC폜
	 */
	public void removeDomain( String domainname ) {
		synchronized( domain ) {
			HashSet domainSet = (HashSet)domain.remove( domainname );
			if( domainSet != null ) {
				domainSet.clear();
			}
		}
	}

	/**
	 * ̃v[̃TCYԂ
	 */
	public int size() {
		int remain = 0;

		synchronized( domain ) {
			Enumeration e = domain.elements();
			while( e.hasMoreElements() ) {
				HashSet s = (HashSet)e.nextElement();
				remain += s.size();
			}
		}

		return remain;
	}

	/*
	 * ̃v[Ƀf[^i[Ă邩ǂԂ
	 */
	public boolean isEmpty() {
		boolean rc = false;
		synchronized( domain ) {
			rc = domain.isEmpty();
		}

		return rc;
	}

	/*
	 * ̃IuWFNg̊ԁCXbh̑҂킹
	 */
	public void waitUntilEmpty() {
		synchronized( domain ) {
			while( domain.isEmpty() == true ) {
				try {
					domain.wait();
				} catch( InterruptedException ie ) {
					// ҂킹IɏIDʂɂȂ炻Ō\
				}
			}
		}
	}
}

// end of URLPool.java
