/**
 * Site
 * TCgǗNX
 */
package org.logical_paradox.rss.http;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Site {
	private RobotAcceptanceRule robotstxt = null;		// robots.txt̓e
	private String siteName = null;						// TCg(FQDN)
	private String url = null;							// URL
	private String robotstxtURL = null;					// robots.txtURL
	public int siteScaleIndex = 0;						// TCgK͎w

	protected Site( String u ) {
		url = u;
	}

	/**
	 * TCgIuWFNg𐶐
	 * Ɏs(=ȃTCgȂƂ)ꍇIOExceptionԂ
	 */
	public static Site getInstance( String url, String userAgent ) throws IllegalArgumentException {
		Site s = new Site( url );

		// robots.txt̔zuꏊ쐬
		URL u = null;

		try {
			u = new URL( url );
		} catch( MalformedURLException ue ) {
			throw new IllegalArgumentException( ue.getMessage() );
		}
		s.siteName = u.getHost() + (u.getPort() > 0 ? ":" + u.getPort() : "");
		s.robotstxtURL = u.getProtocol() + "://" + s.siteName + "/" + "robots.txt";

		return s;
	}

	/**
	 * TCgԂ
	 */
	public String getSiteName() {
		return new String( siteName );
	}

	/**
	 * robots.txtURLԂ
	 */
	public String getRobotsTxtURL() {
		return new String( robotstxtURL );
	}

	/**
	 * w肳ꂽTCgCrobots.txt擾鏈
	 */
	public void getRuleFromTheSite( InputStream src ) throws IOException {
		robotstxt = RobotAcceptanceRule.getInstance( src );
	}

	/**
	 * ̃TCgrobots.txtĂ邩
	 */
	public boolean hasRule() {
		return robotstxt == null ? false : true;
	}


	public boolean isAllowed( String url, String agent ) {
		return robotstxt.isAllowed( url, agent );
	}
}

// end of Site.java
