/*
 * $Id: SyncCommand.java,v 1.3 2005/10/10 12:34:52 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.dsync;

import java.io.Serializable;

/**
 * SyncCommand
 * i[ĂIuWFNgǂ̂悤ɈLqIuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class SyncCommand implements Serializable {
	/** bN擾 */
	public static final int COMMAND_LOCK = 1;
	/** bN */
	public static final int COMMAND_UNLOCK = -1;
	/** URL̓] */
	public static final int COMMAND_FORWARD_URL = 3;
	/** URL̓] */
	public static final int COMMAND_UNFORWARD_URL = -3;
	/** Vbg_E */
	public static final int COMMAND_SHUTDOWN = 255;

	/** ̃R}hɊ֘AtĂIuWFNg */
	private Object _o = null;
	/** ̃R}h̃^Cv */
	private int _commandType = 0;
	/** M */
	private String _from;
	/** M */
	private String _to;

	/**
	 * ftHgRXgN^
	 * 񉻂߂ۂɕKvɂȂ
	 */
	public SyncCommand() {
	}
	/**
	 * RXgN^
	 * @param o IuWFNg
	 * @param type R}h̃^Cv
	 * @param from M
	 * @param to M
	 * @throws IllegalArgumentException R}h^Cv
	 */
	public SyncCommand(Serializable o, int type, String from, String to) throws IllegalArgumentException {
		// R}h̎ނmF
		// R}hǉꍇ́C̔pR[hǉ邱
		if(
			type != COMMAND_LOCK && 
			type != COMMAND_UNLOCK && 
			type != COMMAND_FORWARD_URL &&
			type != COMMAND_UNFORWARD_URL &&
			type != COMMAND_SHUTDOWN
		) {
			throw new IllegalArgumentException("command typesł");
		}

		setObject(o);
		_commandType = type;

		_to = to;
		_from = from;
	}
	/**
	 * ̃R}h̕\Ԃ
	 * @return ̃R}h̕\
	 */
	public String toString() {
		StringBuffer bf = new StringBuffer();
		bf.append("SYC_");

		switch(_commandType) {
			case COMMAND_LOCK:
				bf.append("LO");
				break;

			case COMMAND_UNLOCK:
				bf.append("UL");
				break;

			case COMMAND_FORWARD_URL:
				bf.append("FU");
				break;

			case COMMAND_UNFORWARD_URL:
				bf.append("UF");
				break;

			case COMMAND_SHUTDOWN:
				bf.append("SD");
				break;

			default:
				bf.append("ND");
		}

		bf.append(_o.toString());

		return bf.toString();
	}

	/**
	 * R}h̓]tɂ
	 */
	public void reverse() {
		_commandType = 0 - _commandType;
	}
	/**
	 * o^ĂIuWFNgԂ
	 * @return o^ĂIuWFNg
	 */
	public Object getObject() {
		return _o;
	}
	/**
	 * bZ[WƈꏏɑMf[^
	 * @param o f[^
	 * @throws IllegalArgumentException
	 */
	public void setObject(Serializable o) throws IllegalArgumentException {
		_o = o;
	}
	/**
	 * R}h̎ނԂ
	 * @return ̓R}h̃^Cv
	 */
	public int getType() {
		return _commandType;
	}
	/**
	 * R}h̎ނݒ肷
	 * @param type R}h̎
	 */
	public void setType(int type) {
		_commandType = type;
	}
	/**
	 * MԂ
	 * @return Mm[hID
	 */
	public String getFrom() {
		return _from;
	}
	/**
	 * Mm[hIDݒ肷
	 * @param from Mm[hID
	 */
	public void setFrom(String from) {
		_from = from;
	}
	/**
	 * MԂ
	 * @return Mm[hID
	 */
	public String getTo() {
		return _to;
	}
	/**
	 * Mݒ肷
	 * @param to Mm[hID
	 */
	public void setTo(String to) {
		_to = to;
	}
}

// end of SyncCommand.java
