/*
 * $Id: RSSSyncConfig.java,v 1.2 2005/06/26 14:07:18 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.dsync;

import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

/**
 * RSSSyncConfig
 * T|[gIuWFNg̐ݒt@CIuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class RSSSyncConfig extends RSSConfig {
	/** Ԋu */
	protected int cfgSyncInterval;
	/** L[TCY */
	protected int cfgSyncQueueSize;

	/**
	 * RXgN^
	 * @param str RtBOt@C
	 */
	public RSSSyncConfig(String str) throws IOException, RSSIllegalConfigException {
		super(str);
	}
	/**
	 * ԊuԂ
	 * @return Ԋu
	 */
	public int getSyncInterval() {
		if(cfgSyncInterval <= 0) {
			cfgSyncInterval = 500;
		}
		return cfgSyncInterval;
	}
	/**
	 * L[̃TCYԂ
	 * @return L[̃TCY
	 */
	public int getSyncQueueSize() {
		if(cfgSyncQueueSize <= 0) {
			cfgSyncQueueSize = 200;
		}
		return cfgSyncQueueSize;
	}
	/**
	 * RtBOt@C͂
	 * @return G[bZ[W
	 */
	protected String checkResourceVariables() {
		StringBuffer errmsg = new StringBuffer();

		try {
			cfgSyncInterval = getPropertyAsInt("SYNC_INTERVAL");
		} catch(RSSValueFormatException vfe) {
			errmsg.append("SYNC_INTERVAL̒lsł");
		} catch(RSSNullValueException ne) {}

		try {
			cfgSyncQueueSize = getPropertyAsInt("SYNC_QUEUE_SIZE");
		} catch(RSSValueFormatException vfe) {
			errmsg.append("SYNC_QUEUE_SIZE̒lsł");
		} catch(RSSNullValueException ne) {}

		return errmsg.toString();
	}
}

// end of RSSSyncConfig.java
