/*
 * $Id: DefaultMetricCountingAlgorithm.java,v 1.2 2005/06/30 17:39:06 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.dsr.routing.metrics;

import java.rmi.RemoteException;

import org.logical_paradox.rss.dsr.DSRConstant;
import org.logical_paradox.rss.dsr.routing.Node;

/**
 * ftHg̃gbNvASY
 * w肳ꂽ2m[hԂpingA܂łɂԂgbNlƂASY
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class DefaultMetricCountingAlgorithm implements MetricCountingAlgorithm {
	/**
	 * 2m[hԂ̃gbNv
	 * @param to ̃m[h
	 * @return (gbNl)
	 * @throws MetricCountException gbNvɎs
	 */
	public double count(Node to) throws MetricCountException {
		try {
			long now = DSRConstant.datatime.currentTimeInMillis();
			long reach = to.getRegistry().ping();

			// ʐMɂԂv
			return (double)(reach - now);
		} catch (RemoteException e) {
			// ʐMQ
			throw new MetricCountException(e);
		}
	}

}
