/*
 * $Id: ServiceList.java,v 1.5 2005/07/20 16:40:18 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.dsr;

import java.rmi.Remote;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;

/**
 * ServiceList
 * T[rX̂̃Xg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class ServiceList {
	/** T[rX̃Xg */
	protected final Hashtable list;
	/** T[rX蓖Ă̂߂̃ASY */
	protected final ServiceBindingAlgorithm bindingAlgorithm;

	/**
	 * RXgN^
	 * @param ba T[rXoCfBOASY
	 */
	public ServiceList(ServiceBindingAlgorithm ba) {
		list = new Hashtable();
		bindingAlgorithm = ba;
	}
	/**
	 * RXgN^
	 * @param org ̃Xg
	 * @param ba T[rXoCfBOASY
	 */
	public ServiceList(Hashtable org, ServiceBindingAlgorithm ba) {
		list = org;
		bindingAlgorithm = ba;
	}

	/**
	 * I\ȃ[gT[rXǉ
	 * @param name m[hID
	 * @param JꂽT[rX̃X^u
	 */
	public void add(String name, Remote stub) {
		list.put(name, stub);
	}

	/**
	 * I\ȃ[gT[rX폜(T[rX~ꍇȂ)
	 * @param name m[hID
	 */
	public void remove(String name) {
		list.remove(name);
	}

	/**
	 * I\ȃ[gT[rX̃Ce[^Ԃ
	 * @return T[rX̃Xg|CgĂCe[^
	 */
	public Iterator iterator() {
		return list.keySet().iterator();
	}

	/**
	 * i[ĂT[rX̃m[hID̃XgԂ
	 * @return m[hID̃Xg
	 */
	public String[] serviceNames() {
		synchronized(list) {
			return (String[])list.keySet().toArray(new String[0]);
		}
	}

	/**
	 * w肳ꂽ̂̃T[rXo^Ă邩ǂԂ
	 * @param serviceName m[hID
	 * @return true: / false:Ȃ
	 */
	public boolean contains(String serviceName) {
		return list.containsKey(serviceName);
	}

	/**
	 * i[ĂT[rX̃XgCK؂ȃT[rX̃X^uIĕԂ
	 * @return IꂽT[rX
	 */
	public Service getService() {
		String serviceName = bindingAlgorithm.getService(this);
		if(serviceName != null) {
			return (Service)list.get(serviceName);
		} else {
			return null;
		}
	}

	/**
	 * i[ĂT[rX̃XgCK؂ȃT[rX̃X^uIĕԂ
	 * @param serviceName T[rX
	 * @return IꂽT[rX
	 */
	public Service getService(String serviceName) {
		Service service = (Service)list.get(serviceName);
		return service;
	}
	/**
	 * i[ĂSẴT[rXԂ
	 * @return SẴT[rX
	 */
	public Collection values() {
		return list.values();
	}
}

// end of ServiceList.java
