/*
 * $Id: RSSDistributedServiceRegistry.java,v 1.10 2005/07/18 05:36:16 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.dsr;

import java.rmi.RemoteException;

import org.logical_paradox.rss.Service;

/**
 * RSSDistributedServiceRegistry
 * UT[rXWXg(C^[tF[X)
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.10 $
 */
public interface RSSDistributedServiceRegistry extends Service {
	/** T[rXID: UT[rXWXg */
	public static final int RSS_SERVID_SERVICE_LOCATER = 1;
	/** T[rXID: oHm[h */
	public static final int RSS_SERVID_ROUTING_NODE_CLIENT_FACTORY = 10;
	/** T[rXID: RecǗVXe */
	public static final int RSS_SERVID_REMOTE_CONTENTS_MGR = 20;
	/** T[rXID: CfbNXVXe */
	public static final int RSS_SERVID_INDEX_SERVER = 30;
	/** T[rXID: L[VXe */
	public static final int RSS_SERVID_OQS4R = 40;

	/**
	 * RtBOԂ
	 * @return RtBO[V
	 * @throws RemoteException RtBO̎擾Ɏs
	 */
	public RSSDSRConfig getConfig() throws RemoteException;
	/**
	 * [gT[rXo^
	 * @param type T[rX^Cv
	 * @param stub o^郊[gT[rX
	 * @return ꂽID
	 * @throws RemoteException o^ɎsۂɔO
	 */
	public String bind(int type, Service stub) throws RemoteException;
	/**
	 * [gT[rXo^
	 * T[rXID𖾎IɎwł
	 * @param type T[rX^Cv
	 * @param name T[rXID
	 * @param stub o^郊[gT[rX
	 * @return ꂽID(nameƓl)
	 * @throws RemoteException o^ɎsۂɔO
	 */
	public String bind(int type, String name, Service stub) throws RemoteException;
	/**
	 * w肳ꂽT[rX̓o^
	 * @param type T[rX^Cv
	 * @param nodeId ؂藣m[hID
	 * @throws RemoteException o^ɎsۂɔO
	 */
	public void unbind(int type, String nodeId) throws RemoteException;
	/**
	 * w肳ꂽT[rX̃X^uԂ
	 * @param name T[rX
	 * @return ɃqbgT[rX̃X^u
	 * @throws RemoteException Ɏs
	 */
	public Service getService(String name) throws RemoteException;
	/**
	 * w肳ꂽT[rX̃X^uԂ
	 * @param name T[rX
	 * @param traceLevel T[rXT[x
	 * @return ɃqbgT[rX̃X^u
	 * @throws RemoteException Ɏs
	 */
	public Service getService(String name, int traceLevel) throws RemoteException;
	/**
	 * w肳ꂽT[rXɑΉX^uԂ
	 * @param type T[rX^Cv
	 * @return X^u
	 * @throws RemoteException T[rX̎擾Ɏs
	 */
	public Service getService(int type) throws RemoteException;
	/**
	 * T[rXꗗ
	 * @param type 
	 * @return o^ĂT[rX̔z
	 */
	public String[] services(int type) throws RemoteException;
	/**
	 * wm[hɑ΂pingł
	 * @return m[hbZ[WM(time in millis)
	 * @throws RemoteException pingBȂ
	 */
	public long ping() throws RemoteException;
	/**
	 * DSRԂ̃Nč\z
	 * @throws RemoteException č\zɎs
	 */
	public void configure() throws RemoteException;
	/**
	 * w肳ꂽ^CṽT[rX𕪎Ulbg[N猟,X^uԂ
	 * @param msg T
	 * @return wT͈͂ŔꂽT[rX̃X^u
	 */
	public Service[] discover(Message msg) throws RemoteException;
	/**
	 * w薼̂̃T[rXɓB܂ł̌oHg[XAoHԂ
	 * @param name T[rX
	 * @return g[X
	 * @throws RemoteException g[XɎsۂɔO
	 */
	public Message trace(String name) throws RemoteException;
}

// end of RSSDistributedServiceRegistry.java
