/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RSSDSRConfig.java,v 1.7 2005/07/18 05:36:16 rampil Exp $
 */
package org.logical_paradox.rss.dsr;

import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;

/**
 * RSSDSRConfig
 * UT[rXWXg̃RtBO
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class RSSDSRConfig extends RSSConfig {
	/** ftHg̕Ulbg[NĎԊu */
	public static final int DEFAULT_MONITOR_INTERVAL = 60000;
	/** ftHg̃T[rXT[x */
	public static final int DEFAULT_SERVICE_TRACE_LEVEL = 3;

	/** DSR̖ */
	private String cfgRSSDistributedServiceRegistry;
	/** fobOg[XȌo̓XCb`(true:o / false:o͂Ȃ) */
	private boolean cfgDSRSwDebugTraceLog;
	/** Ȍo̓XCb`(true:o / false:o͂Ȃ) */
	private boolean cfgDSRSwRunLog;
	/** fobOg[XÕt@C */
	private String cfgDebugTraceLogFilename;
	/** Õt@C */
	private String cfgRunLogFilename;
	/** DSRIASY */
	private ServiceBindingAlgorithm cfgDSRBindingAlgorithm;
	/** oHm[hIASY */
	private ServiceBindingAlgorithm cfgRNodeBindingAlgorithm;
	/** RecǗVXeIASY */
	private ServiceBindingAlgorithm cfgRCMGRBindingAlgorithm;
	/** CfbNXVXeIASY */
	private ServiceBindingAlgorithm cfgIndexServerBindingAlgorithm;
	/** L[VXeIASY */
	private ServiceBindingAlgorithm cfgOqs4rBindingAlgorithm;
	/** lbg[NĎo */
	private int cfgMonitorInterval;
	/** T[rXT[x */
	private int cfgTraceLevel;

	/**
	 * RXgN^
	 * @param fn RtBOt@C
	 * @throws IOException RtBOt@C̓ǂݍ݂Ɏs
	 * @throws RSSIllegalConfigException RtBOt@C̓eɖ肪
	 */
	public RSSDSRConfig(String fn) throws IOException, RSSIllegalConfigException {
		super(fn);
		String errmsg = checkResourceVariables();
		if(errmsg != null) {
			throw new RSSIllegalConfigException(errmsg);
		}
	}
	/**
	 * T[rXT[xԂ
	 * @return T[rXT[x
	 */
	public int getTraceLevel() {
		return cfgTraceLevel;
	}
	/**
	 * lbg[NĎԊuԂ(msec)
	 * @return ĎԊu(msec)
	 */
	public int getMonitorInterval() {
		return cfgMonitorInterval;
	}
	/**
	 * DSR̖̂Ԃ
	 * @return DSR̖
	 */
	public String getRSSDistributedServiceRegistry() {
		return cfgRSSDistributedServiceRegistry;
	}
	/**
	 * fobOg[XȌo̓XCb`Ԃ
	 * @return true:o / false:o͂Ȃ
	 */
	public boolean getDSRSwDebugTraceLog() {
		return cfgDSRSwDebugTraceLog;
	}
	/**
	 * Ȍo̓XCb`Ԃ
	 * @return true:o / false:o͂Ȃ
	 */
	public boolean getDSRSwRunLog() {
		return cfgDSRSwRunLog;
	}
	/**
	 * fobOg[XÕt@CԂ
	 * @return fobOg[XÕt@C
	 */
	public String getDebugTraceLogFilename() {
		return cfgDebugTraceLogFilename;
	}
	/**
	 * Õt@CԂ
	 * @return Õt@C
	 */
	public String getRunLogFilename() {
		return cfgRunLogFilename;
	}
	/**
	 * DSRIASYԂ
	 * @return DSRIASY
	 */
	public ServiceBindingAlgorithm getDSRBindingAlgorithm() {
		return cfgDSRBindingAlgorithm;
	}
	/**
	 * oHm[hIASYԂ
	 * @return oHm[hIASY
	 */
	public ServiceBindingAlgorithm getRNodeBindingAlgorithm() {
		return cfgRNodeBindingAlgorithm;
	}
	/**
	 * RecǗVXeIASYԂ
	 * @return RecǗVXeIASY
	 */
	public ServiceBindingAlgorithm getRCMGRBindingAlgorithm() {
		return cfgRCMGRBindingAlgorithm;
	}
	/**
	 * CfbNXVXeIASYԂ
	 * @return CfbNXVXeIASY
	 */
	public ServiceBindingAlgorithm getIndexServerBindingAlgorithm() {
		return cfgIndexServerBindingAlgorithm;
	}
	/**
	 * L[VXeIASYԂ
	 * @return L[VXeIASY
	 */
	public ServiceBindingAlgorithm getOqs4rBindingAlgorithm() {
		return cfgOqs4rBindingAlgorithm;
	}
	/**
	 * p[^mF\bh
	 * @return G[bZ[W
	 */
	protected String checkResourceVariables() {
		StringBuffer errmsg = new StringBuffer();

		if(getProperty("RSS_DSR") != null) {
			cfgRSSDistributedServiceRegistry = getProperty("RSS_DSR");
		} else {
			errmsg.append("RSS_DSRw肳Ă܂D\n");
		}

		try {
			cfgDSRSwDebugTraceLog = getPropertyAsBool("DSR_SW_DEBUG_TRACE_LOG");
		} catch(RSSValueFormatException vfe) {
			errmsg.append("DSR_SW_DEBUG_TRACE_LOGsł\n");
		} catch(RSSNullValueException ne) {}

		try {
			cfgDSRSwRunLog = getPropertyAsBool("DSR_SW_RUNLOG");
		} catch(RSSValueFormatException vfe) {
			errmsg.append("DSR_SW_RUNLOGsł\n");
		} catch(RSSNullValueException ne) {}

		if(getProperty("DEBUG_TRACE_LOG_FILENAME") != null) {
			cfgDebugTraceLogFilename = getProperty("DEBUG_TRACE_LOG_FILENAME");
		} else {
			errmsg.append("DEBUG_TRACE_LOG_FILENAMEw肳Ă܂D\n");
		}

		if(getProperty("RUNLOG_FILENAME") != null) {
			cfgRunLogFilename = getProperty("RUNLOG_FILENAME");
		} else {
			errmsg.append("RUNLOG_FILENAMEw肳Ă܂D\n");
		}


		try {
			if(getProperty("DSR_BINDING_ALGORITHM") != null) {
				cfgDSRBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(getProperty("DSR_BINDING_ALGORITHM")).newInstance();
			} else {
				errmsg.append("DSR_BINDING_ALGORITHMw肳Ă܂D\n");
			}
		} catch(Exception slBindingAlgorithmExp) {
			errmsg.append(getProperty("RNODE_BINDING_ALGORITHM") + "̃CX^XɗO܂: " + slBindingAlgorithmExp.getMessage());
		}

		try {
			if(getProperty("RNODE_BINDING_ALGORITHM") != null) {
				cfgRNodeBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(getProperty("RNODE_BINDING_ALGORITHM")).newInstance();
			} else {
				errmsg.append("RNODE_BINDING_ALGORITHMw肳Ă܂D\n");
			}
		} catch(Exception rnodeBindingAlgorithmExp) {
			errmsg.append(getProperty("RNODE_BINDING_ALGORITHM") + "̃CX^XɗO܂: " + rnodeBindingAlgorithmExp.getMessage());
		}
		try {
			if(getProperty("RCMGR_BINDING_ALGORITHM") != null) {
				cfgRCMGRBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(getProperty("RCMGR_BINDING_ALGORITHM")).newInstance();
			} else {
				errmsg.append("RCMGR_BINDING_ALGORITHMw肳Ă܂D\n");
			}
		} catch(Exception rcmgrBindingAlgorithmExp) {
			errmsg.append(getProperty("RNODE_BINDING_ALGORITHM") + "̃CX^XɗO܂: " + rcmgrBindingAlgorithmExp.getMessage());
		}
		try {
			if(getProperty("IDXSRV_BINDING_ALGORITHM") != null) {
				cfgIndexServerBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(getProperty("IDXSRV_BINDING_ALGORITHM")).newInstance();
			} else {
				errmsg.append("IDXSRV_BINDING_ALGORITHMD\n");
			}
		} catch(Exception idxsrvBindingAlgorithmExp) {
			errmsg.append(getProperty("IDXSRV_BINDING_ALGORITHM") + "̃CX^XɗO܂: " + idxsrvBindingAlgorithmExp.getMessage());
		}
		try {
			if(getProperty("OQS4R_BINDING_ALGORITHM") != null) {
				cfgOqs4rBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName(getProperty("OQS4R_BINDING_ALGORITHM")).newInstance();
			} else {
				errmsg.append("IDXSRV_BINDING_ALGORITHMD\n");
			}
		} catch(Exception oqs4rBindingAlgorithmExp) {
			errmsg.append(getProperty("OQS4R_BINDING_ALGORITHM") + "̃CX^XɗO܂: " + oqs4rBindingAlgorithmExp.getMessage());
		}

		try {
			if(getProperty("MONITOR_INTERVAL") != null) {
				cfgMonitorInterval = getPropertyAsInt("MONITOR_INTERVAL");
			} else {
				cfgMonitorInterval = DEFAULT_MONITOR_INTERVAL;
			}
		} catch(Exception oqs4rBindingAlgorithmExp) {
			errmsg.append(getProperty("MONITOR_INTERVAL") + "̃CX^XɗO܂: " + oqs4rBindingAlgorithmExp.getMessage());
		}
		try {
			if(getProperty("SERVICE_TRACE_LEVEL") != null) {
				cfgTraceLevel = getPropertyAsInt("SERVICE_TRACE_LEVEL");
			} else {
				cfgTraceLevel = DEFAULT_SERVICE_TRACE_LEVEL;
			}
		} catch(Exception e) {
			errmsg.append(getProperty("SERVICE_TRACE_LEVEL") + "̃CX^XɗO܂: " + e.getMessage());
		}

		if(errmsg.toString().trim().length() == 0) {
			return null;
		} else {
			return errmsg.toString();
		}
	}
}

// end of RSSDSRConfig.java
