/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import org.logical_paradox.common.io.ByteStream;
import org.logical_paradox.common.io.ExpandableBuffer;

public abstract class ArrayListByteStream
extends ArrayList
implements ByteStream {
    public ArrayListByteStream() {
    }

    public ArrayListByteStream(ByteStream[] bs) {
        this.add(bs);
    }

    public ArrayListByteStream(byte[] bs) {
        this.byteStreamToObject(bs);
    }

    public byte[] byteStream() {
        ExpandableBuffer buffer = new ExpandableBuffer();
        try {
            ArrayListByteStream arrayListByteStream = this;
            synchronized (arrayListByteStream) {
                byte[] element = null;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ByteStream bs = (ByteStream)it.next();
                    element = bs.byteStream();
                    buffer.write(element.length & 0xFF000000);
                    buffer.write(element.length & 0xFF0000);
                    buffer.write(element.length & 0xFF00);
                    buffer.write(element.length & 0xFF);
                    buffer.write(element);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return buffer.byteStream();
    }

    protected void byteStreamToObject(byte[] bstream) {
        ByteBuffer buffer = ByteBuffer.allocate(bstream.length).order(ByteOrder.BIG_ENDIAN);
        buffer.put(bstream);
        buffer.rewind();
        while (buffer.hasRemaining()) {
            int objectByteSize = buffer.getInt();
            byte[] objectBody = new byte[objectByteSize];
            buffer.get(objectBody);
            this.add(this.buildByteStreamObject(objectBody));
        }
    }

    protected abstract ByteStream buildByteStreamObject(byte[] var1);
}

