/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.io;

import java.io.EOFException;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.common.io.MemoryMappedRandomAccessFile;

public class MemoryMappedRandomAccessFileTest
extends TestCase {
    public MemoryMappedRandomAccessFileTest(String arg0) {
        super(arg0);
    }

    public void testReadAndWrite() throws Exception {
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        Assert.assertEquals((long)0L, (long)file.length());
        file.write(new String("123456789").getBytes());
        Assert.assertEquals((long)9L, (long)file.length());
        file.seek(0L);
        byte[] b1 = new byte["123456789".length()];
        file.read(b1);
        Assert.assertEquals((String)"123456789", (String)new String(b1));
    }

    public void testClose() throws Exception {
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        file.close();
        try {
            file.close();
            Assert.fail((String)"\u4e00\u5ea6\u30af\u30ed\u30fc\u30ba\u3057\u305f\u306e\u306b\u307e\u305f\u30af\u30ed\u30fc\u30ba\u3067\u304d\u305f");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testSeek() throws Exception {
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        file.write(new String("1234567890").getBytes());
        try {
            file.seek(10L);
        }
        catch (IOException i1) {
            Assert.fail((String)"\u304a\u304b\u3057\u30441");
        }
        try {
            file.seek(11L);
            Assert.fail((String)"10\u30d0\u30a4\u30c8\u3067seek(11)\u306f\u30a8\u30e9\u30fc\u306b\u306a\u308b\u306f\u305a");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file.seek(-1L);
            Assert.fail((String)"seek(-1)\u306f\u30a8\u30e9\u30fc\u306e\u306f\u305a");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testReadAndWriteByInt() throws Exception {
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        byte[] b2 = new byte[]{100, 127, 5};
        file.write(b2);
        try {
            file.seek(0L);
            int i2 = file.readInt();
            Assert.fail((String)"EOFException\u304c\u767a\u751f\u3059\u308b\u306f\u305a");
        }
        catch (EOFException i2) {
            // empty catch block
        }
        byte[] b = new byte[]{100, 127, 21, 21};
        file.write(b);
        file.seek(0L);
        int i = file.readInt();
    }
}

