/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.logical_paradox.common.io.ExpandableBuffer;
import org.logical_paradox.common.io.RandomAccessFileDelegator;

public class MemoryMappedRandomAccessFile
implements RandomAccessFileDelegator {
    private boolean _closed = false;
    private ExpandableBuffer _buffer = new ExpandableBuffer();

    public void close() throws IOException {
        if (this._closed) {
            throw new IOException("\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u9589\u3058\u3089\u308c\u3066\u3044\u307e\u3059");
        }
        this._closed = true;
    }

    public long length() throws IOException {
        return this._buffer.using();
    }

    public void seek(long pos) throws IOException {
        if (pos > this.length()) {
            throw new IOException("\u30b7\u30fc\u30af\u30dd\u30a4\u30f3\u30bf\u304c\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u306e\u7d42\u7aef\u3092\u8d8a\u3048\u305f");
        }
        if (pos < 0L) {
            throw new IOException("\u30b7\u30fc\u30af\u30dd\u30a4\u30f3\u30bf\u306f0\u4ee5\u4e0a\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        this._buffer.seek((int)pos);
    }

    public int read(byte[] b) throws IOException {
        return this._buffer.getInputStream().read(b);
    }

    public void readFully(byte[] b) throws IOException {
        this.read(b);
    }

    public byte readByte() throws IOException {
        int b = this._buffer.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public int readInt() throws IOException, EOFException {
        int b1 = this.readByte() & 0xFF;
        int b2 = this.readByte() & 0xFF;
        int b3 = this.readByte() & 0xFF;
        int b4 = this.readByte() & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public long readLong() throws IOException, EOFException {
        int b1 = this.readByte() & 0xFF;
        int b2 = this.readByte() & 0xFF;
        int b3 = this.readByte() & 0xFF;
        int b4 = this.readByte() & 0xFF;
        int b5 = this.readByte() & 0xFF;
        int b6 = this.readByte() & 0xFF;
        int b7 = this.readByte() & 0xFF;
        int b8 = this.readByte() & 0xFF;
        return b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8;
    }

    public void write(byte[] b) throws IOException {
        this._buffer.getOutputStream().write(b);
    }

    public void write(int b) throws IOException {
        this._buffer.write(b);
    }

    public OutputStream getOutputStream() {
        return this._buffer.getOutputStream();
    }

    public InputStream getInputStream() {
        return this._buffer.getInputStream();
    }
}

