/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.io;

import java.io.InputStream;
import java.io.PrintWriter;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.common.io.ExpandableBuffer;

public class ExpandableBufferTest
extends TestCase {
    public ExpandableBufferTest(String arg0) {
        super(arg0);
    }

    public void testAutomaticExpand() throws Exception {
        ExpandableBuffer buffer = new ExpandableBuffer(8);
        Assert.assertTrue((String)"\u30d0\u30c3\u30d5\u30a1\u30b5\u30a4\u30ba\u304c\u521d\u671f\u30d6\u30ed\u30c3\u30af\u30b5\u30a4\u30ba\u3067\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044", (buffer.size() == 8 ? 1 : 0) != 0);
        byte[] str = "12345678901234567890".getBytes();
        buffer.write(str);
        Assert.assertTrue((String)"\u62e1\u5f35\u3055\u308c\u305f\u30b5\u30a4\u30ba\u304c\u304a\u304b\u3057\u3044", (buffer.size() == 24 ? 1 : 0) != 0);
        Assert.assertTrue((String)("\u5360\u6709\u30b5\u30a4\u30ba\u304c\u304a\u304b\u3057\u3044:" + buffer.using()), (buffer.using() == 20 ? 1 : 0) != 0);
        buffer.seek(0);
        InputStream istream = buffer.getInputStream();
        int b = 0;
        int i = 0;
        while ((b = istream.read()) > 0) {
            Assert.assertEquals((String)"\u6bd4\u8f03\u306b\u5931\u6557", (byte)str[i], (byte)((byte)b));
            ++i;
        }
    }

    public void testOutputStream() throws Exception {
        ExpandableBuffer buffer = new ExpandableBuffer(8);
        Assert.assertTrue((String)"\u30d0\u30c3\u30d5\u30a1\u30b5\u30a4\u30ba\u304c\u521d\u671f\u30d6\u30ed\u30c3\u30af\u30b5\u30a4\u30ba\u3067\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044", (buffer.size() == 8 ? 1 : 0) != 0);
        PrintWriter out = new PrintWriter(buffer.getOutputStream());
        out.print("****111122223333");
        out.flush();
        Assert.assertTrue((String)"\u30b7\u30fc\u30af\u30dd\u30a4\u30f3\u30bf\u304c\u9032\u3093\u3067\u3044\u306a\u3044", (buffer.using() > 0 ? 1 : 0) != 0);
        InputStream istream = buffer.getInputStream();
        buffer.seek(0);
        byte[] str = new byte[buffer.using()];
        byte b = 0;
        int i = 0;
        while ((b = (byte)istream.read()) > 0) {
            str[i++] = b;
        }
        Assert.assertEquals((String)("\u5fa9\u5143\u3057\u305f\u6587\u5b57\u5217\u304c\u9055\u3046:" + new String(str)), (String)"****111122223333", (String)new String(str));
    }

    public void testByteStream() throws Exception {
        ExpandableBuffer buffer = new ExpandableBuffer();
        buffer.write(255);
        buffer.write(254);
        buffer.write(253);
        byte[] array = buffer.byteStream();
        Assert.assertEquals((int)3, (int)array.length);
        Assert.assertEquals((byte)-1, (byte)array[0]);
        Assert.assertEquals((byte)-2, (byte)array[1]);
        Assert.assertEquals((byte)-3, (byte)array[2]);
    }
}

