/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.xa;

import com.mysql.jdbc.xa.TxConnection;
import com.mysql.jdbc.xa.XAConnectionImpl;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.Xid;

public abstract class XADataSourceImpl
implements DataSource,
Serializable,
Runnable {
    private transient Hashtable _txConnections = new Hashtable();
    private transient ArrayList _pool = new ArrayList();
    private transient Thread _background = new Thread((Runnable)this, "XADataSource Timeout Daemon");
    private int _txTimeout = 10;
    public static final int DEFAULT_TX_TIMEOUT = 10;

    public XADataSourceImpl() {
        this._background.setPriority(1);
        this._background.setDaemon(true);
        this._background.start();
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(null, null);
    }

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        return new XAConnectionImpl(this, this.newConnection(string, string2), string, string2);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(null, null);
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        return new XAConnectionImpl(this, this.newConnection(string, string2), string, string2);
    }

    public int getTransactionTimeout() {
        return this._txTimeout;
    }

    public abstract PrintWriter getLogWriter();

    public void setTransactionTimeout(int n) {
        this._txTimeout = n <= 0 ? 10 : n;
        this._background.interrupt();
    }

    TxConnection getTxConnection(Xid xid) {
        return (TxConnection)this._txConnections.get(xid);
    }

    TxConnection setTxConnection(Xid xid, TxConnection txConnection) {
        if (txConnection == null) {
            return (TxConnection)this._txConnections.remove(xid);
        }
        return this._txConnections.put(xid, txConnection);
    }

    void releaseConnection(Connection connection, String string, String string2) {
        if (null != connection) {
            ArrayList arrayList = this._pool;
            synchronized (arrayList) {
                this._pool.add(new ConnectionEntry(connection, this.getAccount(string, string2)));
            }
        }
    }

    private String getAccount(String string, String string2) {
        if (string == null) {
            return "";
        }
        if (string2 == null) {
            return string;
        }
        return string + ":" + string2;
    }

    Connection newConnection(String string, String string2) throws SQLException {
        ArrayList arrayList = this._pool;
        synchronized (arrayList) {
            if (!this._pool.isEmpty()) {
                String string3 = this.getAccount(string, string2);
                Iterator iterator = ((AbstractList)this._pool).iterator();
                while (iterator.hasNext()) {
                    ConnectionEntry connectionEntry = (ConnectionEntry)iterator.next();
                    if (!connectionEntry._account.equals(string3)) continue;
                    iterator.remove();
                    Connection connection = connectionEntry._connection;
                    return connection;
                }
            }
        }
        Connection connection = this.getConnection(string, string2);
        return connection;
    }

    Xid[] getTxRecover() {
        Vector<Xid> vector = new Vector<Xid>();
        Enumeration enumeration = this._txConnections.elements();
        while (enumeration.hasMoreElements()) {
            TxConnection txConnection = (TxConnection)enumeration.nextElement();
            if (txConnection.conn == null || !txConnection.prepared) continue;
            vector.add(txConnection.xid);
        }
        return (Xid[])vector.toArray();
    }

    public int isolationLevel() {
        return 0;
    }

    public void run() {
        block15: while (true) {
            Object object;
            block23: {
                try {
                    Thread.sleep(this._txTimeout * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    int n = this._pool.size();
                    int n2 = n - n / 10 - 1;
                    if (n2 < 0 || n <= n2) break block23;
                    if (this.getLogWriter() != null) {
                        this.getLogWriter().println("DataSource " + this.toString() + ": Reducing internal connection pool size from " + n + " to " + n2);
                    }
                    object = ((AbstractList)this._pool).iterator();
                    do {
                        try {
                            ((ConnectionEntry)object.next())._connection.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        object.remove();
                    } while (--n > n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long l = System.currentTimeMillis();
            Enumeration enumeration = this._txConnections.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) continue block15;
                TxConnection txConnection = (TxConnection)enumeration.nextElement();
                if (txConnection.conn == null) {
                    this._txConnections.remove(txConnection.xid);
                    enumeration = this._txConnections.elements();
                    continue;
                }
                if (txConnection.timeout >= l) continue;
                try {
                    object = txConnection;
                    synchronized (object) {
                        if (txConnection.conn == null) {
                            continue;
                        }
                        if (this.getLogWriter() != null) {
                            this.getLogWriter().println("DataSource " + this.toString() + ": Transaction timed out and being aborted: " + txConnection.xid);
                        }
                        Connection connection = txConnection.conn;
                        txConnection.conn = null;
                        txConnection.timedOut = true;
                        try {
                            connection.rollback();
                            this.releaseConnection(connection, txConnection.userName, txConnection.password);
                        }
                        catch (SQLException sQLException) {
                            if (this.getLogWriter() != null) {
                                this.getLogWriter().println("DataSource " + this.toString() + ": Error aborting timed out transaction: " + sQLException);
                            }
                            try {
                                connection.close();
                            }
                            catch (SQLException sQLException2) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            break;
        }
    }

    public void debug(PrintWriter printWriter) {
        printWriter.println("Debug info for XADataSource:");
        Enumeration enumeration = this._txConnections.elements();
        if (!enumeration.hasMoreElements()) {
            printWriter.println("Empty");
        }
        while (enumeration.hasMoreElements()) {
            StringBuffer stringBuffer = new StringBuffer();
            TxConnection txConnection = (TxConnection)enumeration.nextElement();
            stringBuffer.append("TxConnection ");
            if (txConnection.xid != null) {
                stringBuffer.append(txConnection.xid);
            }
            if (txConnection.conn != null) {
                stringBuffer.append(' ').append(txConnection.conn);
            }
            stringBuffer.append(" count: ").append(txConnection.count);
            if (txConnection.prepared) {
                stringBuffer.append(" prepared");
            }
            if (txConnection.timedOut) {
                stringBuffer.append(" timed-out");
            }
            if (txConnection.readOnly) {
                stringBuffer.append(" read-only");
            }
            printWriter.println(stringBuffer.toString());
        }
        Iterator iterator = ((AbstractList)this._pool).iterator();
        while (iterator.hasNext()) {
            printWriter.println("Pooled underlying: " + iterator.next().toString());
        }
    }

    public abstract void setLoginTimeout(int var1) throws SQLException;

    public abstract void setLogWriter(PrintWriter var1) throws SQLException;

    public abstract int getLoginTimeout() throws SQLException;

    public abstract Connection getConnection(String var1, String var2) throws SQLException;

    public abstract Connection getConnection() throws SQLException;

    private static class ConnectionEntry {
        private final String _account;
        private final Connection _connection;

        private ConnectionEntry(Connection connection, String string) {
            this._connection = connection;
            this._account = string;
        }

        public String toString() {
            return this._connection.toString();
        }
    }
}

