/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm.accessor.mysql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.rcm.RSSContentsMngrServiceImpl;
import org.logical_paradox.rss.rcm.RSSRCMConfig;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.accessor.simple.VirtualQueueServer;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;
import org.logical_paradox.rss.util.DocumentIdGenerator;

public class DbmysqlContentsAccessor
implements ContentsAccessor {
    private static final Log log = LogFactory.getLog((Class)(class$org$logical_paradox$rss$rcm$accessor$mysql$DbmysqlContentsAccessor == null ? (class$org$logical_paradox$rss$rcm$accessor$mysql$DbmysqlContentsAccessor = DbmysqlContentsAccessor.class$("org.logical_paradox.rss.rcm.accessor.mysql.DbmysqlContentsAccessor")) : class$org$logical_paradox$rss$rcm$accessor$mysql$DbmysqlContentsAccessor));
    private boolean activeFlag = false;
    private Connection con = null;
    private VirtualQueueServer queue = null;
    private static DataFilter dataFilter = null;
    static /* synthetic */ Class class$org$logical_paradox$rss$rcm$accessor$mysql$DbmysqlContentsAccessor;

    public void init(String initparam) {
        this.open(initparam);
    }

    public synchronized void open(String openstr) {
        if (this.isActive()) {
            return;
        }
        if (openstr == null || openstr.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            this.con = DriverManager.getConnection(openstr);
            this.activeFlag = true;
            this.queue = new VirtualQueueServer(new RSSRCMConfig(RSSContentsMngrServiceImpl.RCM_CONF_FILENAME).getRSSDistributedServiceRegistry());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void regist(String url, String contents) {
        if (!this.isActive() || url == null || url.trim().length() == 0) {
            throw new IllegalStateException();
        }
        String sql = "insert into contents values(null,?,?,?,?,?)";
        byte[] barray = new byte[]{};
        try {
            barray = dataFilter.compressContents(contents.getBytes());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ByteArrayInputStream bi = new ByteArrayInputStream(barray);
        String sitename = "site site";
        String title = "document title";
        try {
            String digest = dataFilter.filterURL(url);
            PreparedStatement pstmt = this.con.prepareStatement(sql);
            pstmt.setString(1, digest);
            pstmt.setString(2, sitename);
            pstmt.setString(3, title);
            pstmt.setString(4, url);
            pstmt.setBinaryStream(5, (InputStream)bi, barray.length);
            pstmt.executeUpdate();
            pstmt.close();
            sql = "select last_insert_id() as did from contents";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            if (rs.next()) {
                long did = rs.getLong("did");
                String documentId = DocumentIdGenerator.getDocumentId((long)did, (String)digest);
                this.queue.enqueue(documentId);
            } else {
                log.warn((Object)"\u4f55\u3089\u304b\u306e\u539f\u56e0\u3067\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u756a\u53f7\u3092\u767a\u756a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregist(String url) {
        if (!this.isActive() || url == null || url.trim().length() == 0) {
            throw new IllegalStateException();
        }
        String sql = "delete from contents where mkey=?";
        PreparedStatement pstmt = null;
        pstmt = this.con.prepareStatement(sql);
        pstmt.setString(1, url);
        pstmt.executeUpdate(sql);
        Object var6_4 = null;
        if (pstmt == null) return;
        try {
            pstmt.close();
            return;
        }
        catch (SQLException e) {}
        return;
        {
            catch (SQLException se) {
                Object var6_5 = null;
                if (pstmt == null) return;
                try {
                    pstmt.close();
                    return;
                }
                catch (SQLException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (pstmt == null) throw throwable;
            try {
                pstmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregistAll() {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
        String sql = "delete from contents";
        Statement st = null;
        st = this.con.createStatement();
        st.executeUpdate(sql);
        Object var5_3 = null;
        if (st == null) return;
        try {
            st.close();
            return;
        }
        catch (SQLException e) {}
        return;
        {
            catch (SQLException sQLException) {
                Object var5_4 = null;
                if (st == null) return;
                try {
                    st.close();
                    return;
                }
                catch (SQLException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (st == null) throw throwable;
            try {
                st.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String find(String url) {
        String contents;
        block21: {
            SQLException e222;
            ResultSet rs;
            PreparedStatement pstmt;
            block19: {
                block18: {
                    if (!this.isActive() || url == null || url.trim().length() == 0) {
                        throw new IllegalStateException();
                    }
                    String sql = "select * from contents where mkey=?";
                    contents = null;
                    pstmt = null;
                    rs = null;
                    pstmt = this.con.prepareStatement(sql);
                    pstmt.setString(1, url);
                    rs = pstmt.executeQuery(sql);
                    if (!rs.next()) break block18;
                    contents = rs.getString(1);
                }
                Object var8_6 = null;
                if (rs == null) break block19;
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e222) {}
            }
            break block21;
            {
                catch (SQLException se) {
                    SQLException e222;
                    Object var8_7 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e222;
                Object var8_8 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return contents;
    }

    public synchronized void close() {
        if (!this.isActive()) {
            throw new IllegalStateException("connector has already been closed");
        }
        try {
            if (this.con != null) {
                this.con.close();
                this.con = null;
            }
            this.activeFlag = false;
        }
        catch (SQLException se) {
            throw new IllegalStateException(se.getMessage());
        }
    }

    protected boolean isActive() {
        return this.activeFlag;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        dataFilter = DataFilterFactory.getFilter((int)1);
    }
}

