/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.BtreeManipulationException;

public class BtreePage {
    public static final long NEW_PAGE = -1L;
    private final int _order;
    private long _pageno;
    private BtreeKey[] _keys;
    private long[] _children;
    private int _keyCount;
    private final BtreeKey[] _tempForPromoKey;
    private final long[] _tempForPromoPtr;
    private final BtreeFactory _factory;
    private boolean enabled = true;

    protected BtreePage(BtreeFactory factory, long pageno, BtreeKey[] keys, long[] children) throws BtreeException {
        this._factory = factory;
        int order = Integer.parseInt(factory.getProperty().getProperty("btreefile.order"));
        if (order <= 0 || pageno < 0L) {
            throw new BtreeException("\u6b21\u6570\u307e\u305f\u306f\u30da\u30fc\u30b8\u756a\u53f7\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this._order = order;
        this._pageno = pageno;
        this._keys = new BtreeKey[order];
        this._children = new long[order + 1];
        this._keyCount = 0;
        this.init();
        this._tempForPromoKey = new BtreeKey[order + 1];
        this._tempForPromoPtr = new long[order + 1 + 1];
        System.arraycopy(keys, 0, this._keys, 0, keys.length);
        System.arraycopy(children, 0, this._children, 0, children.length);
        this._keyCount = keys.length;
        this.cleanTemp();
    }

    BtreePage(BtreeFactory factory, long pageno) throws BtreeException {
        this._factory = factory;
        int order = Integer.parseInt(factory.getProperty().getProperty("btreefile.order"));
        if (order <= 0 || pageno < 0L) {
            throw new BtreeException("\u6b21\u6570\u307e\u305f\u306f\u30da\u30fc\u30b8\u756a\u53f7\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this._order = order;
        this._pageno = pageno;
        this._keys = new BtreeKey[order];
        this._children = new long[order + 1];
        this._keyCount = 0;
        this._tempForPromoKey = new BtreeKey[order + 1];
        this._tempForPromoPtr = new long[order + 1 + 1];
        this.init();
        this.cleanTemp();
    }

    BtreePage(BtreeFactory factory, long pageno, byte[] page) throws BtreeException {
        this._factory = factory;
        int order = Integer.parseInt(factory.getProperty().getProperty("btreefile.order"));
        if (order <= 0 || pageno < 0L) {
            throw new BtreeException("\u6b21\u6570\u307e\u305f\u306f\u30da\u30fc\u30b8\u756a\u53f7\u304c\u4e0d\u6b63\u3067\u3059");
        }
        if (page == null || page.length == 0) {
            throw new BtreeException("\u5fa9\u5143\u3059\u308b\u30da\u30fc\u30b8\u306e\u30d0\u30a4\u30c8\u5217\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u304b\uff0c\u30d0\u30a4\u30c8\u5217\u304c\u7a7a\u3067\u3059");
        }
        this._order = order;
        this._pageno = pageno;
        this._keys = new BtreeKey[order];
        this._children = new long[order + 1];
        this._keyCount = 0;
        this._tempForPromoKey = new BtreeKey[order + 1];
        this._tempForPromoPtr = new long[order + 1 + 1];
        this.init();
        this.cleanTemp();
        this.byteStreamToBtreePage(page, Integer.parseInt(factory.getProperty().getProperty("btreefile.keysize")));
    }

    public long getPageNo() {
        return this._pageno;
    }

    public void setPageNo(long pn) {
        this._pageno = pn;
    }

    public int keyCount() {
        return this._keyCount;
    }

    public int order() {
        return this._order;
    }

    public int children() {
        return this._children.length;
    }

    public synchronized BtreeKey[] getKeys() {
        BtreeKey[] bkeys = new BtreeKey[this._keyCount];
        System.arraycopy(this._keys, 0, bkeys, 0, this._keyCount);
        return bkeys;
    }

    public synchronized PromoResult insert(BtreeKey ikey, long rchild) throws BtreeException, BtreeManipulationException, IOException {
        if (ikey == null) {
            throw new BtreeManipulationException("\u30ad\u30fc\u304cNULL\u3067\u3059");
        }
        this.cleanTemp();
        int pkey = 0;
        int ptmp = 0;
        boolean isCopied = false;
        boolean isReplaced = false;
        this._tempForPromoPtr[0] = this._children[0];
        boolean cnt = false;
        while (pkey < this._keyCount) {
            if (this._keys[pkey].equals(ikey)) {
                this._keys[pkey] = ikey;
                isCopied = true;
                isReplaced = true;
            } else if (!isCopied && ikey.isLessThan(this._keys[pkey])) {
                this._tempForPromoKey[ptmp++] = ikey;
                this._tempForPromoPtr[ptmp] = rchild;
                isCopied = true;
            }
            this._tempForPromoKey[ptmp++] = this._keys[pkey++];
            this._tempForPromoPtr[ptmp] = this._children[pkey];
        }
        if (!isCopied) {
            this._tempForPromoKey[ptmp++] = ikey;
            this._tempForPromoPtr[ptmp] = rchild;
        }
        if (isReplaced) {
            return null;
        }
        if (this._keyCount < this._order) {
            System.arraycopy(this._tempForPromoKey, 0, this._keys, 0, this._keyCount + 1);
            System.arraycopy(this._tempForPromoPtr, 0, this._children, 0, this._keyCount + 2);
            if (!isReplaced) {
                ++this._keyCount;
            }
            return null;
        }
        int promoKeyIdx = this._order / 2 + this._order % 2;
        BtreeKey promoKey = this._tempForPromoKey[promoKeyIdx];
        BtreeKey[] brotherKeys = new BtreeKey[this._tempForPromoKey.length - 1 - promoKeyIdx];
        long[] brotherChildren = new long[brotherKeys.length + 1];
        System.arraycopy(this._tempForPromoKey, promoKeyIdx + 1, brotherKeys, 0, brotherKeys.length);
        System.arraycopy(this._tempForPromoPtr, promoKeyIdx + 1, brotherChildren, 0, brotherKeys.length + 1);
        BtreePage brother = new BtreePage(this._factory, this._pageno + 1L, brotherKeys, brotherChildren);
        this._keys = new BtreeKey[this._order];
        this._children = new long[this._order + 1];
        System.arraycopy(this._tempForPromoKey, 0, this._keys, 0, promoKeyIdx);
        System.arraycopy(this._tempForPromoPtr, 0, this._children, 0, promoKeyIdx + 1);
        this._keyCount = promoKeyIdx;
        PromoResult pr = new PromoResult(promoKey, brother);
        return pr;
    }

    public BtreeKey find(String key) {
        int i = 0;
        while (i < this._keyCount) {
            if (key.equals(this._keys[i].toString())) {
                return this._keys[i];
            }
            ++i;
        }
        return null;
    }

    public boolean shouldBeContained(BtreeKey key) {
        return this.getChildPageNo(key) < 0L;
    }

    void setChildNodeAt(int idx, long pageno) {
        this._children[idx] = pageno;
    }

    public long getChildNodeAt(int idx) {
        return this._children[idx];
    }

    public void setLeftChildOf(BtreeKey key, long pageno) {
        int i = 0;
        while (i < this._keyCount) {
            if (key.equals(this._keys[i].toString())) {
                this._children[i] = pageno;
                return;
            }
            ++i;
        }
    }

    public void setRightChildOf(BtreeKey key, long pageno) {
        int i = 0;
        while (i < this._keyCount) {
            if (key.equals(this._keys[i].toString())) {
                this._children[i + 1] = pageno;
                return;
            }
            ++i;
        }
    }

    public long getChildPageNo(BtreeKey key) {
        if (this._keyCount == 0) {
            return -2L;
        }
        Object theGreaterKey = null;
        int offsetOfTheGreaterKey = -1;
        int i = 0;
        while (i < this._keyCount) {
            if (key.equals(this._keys[i])) {
                return -2L;
            }
            if (key.isLessThan(this._keys[i])) {
                offsetOfTheGreaterKey = i;
                break;
            }
            ++i;
        }
        if (offsetOfTheGreaterKey == -1) {
            if (this.getChildNodeAt(this._keyCount) > 0L) {
                return this.getChildNodeAt(this._keyCount);
            }
            return -2L;
        }
        if (this._children[offsetOfTheGreaterKey] >= 0L) {
            return this._children[offsetOfTheGreaterKey];
        }
        return -1L;
    }

    public boolean isContained(BtreeKey key) {
        return this.find(key.toString()) != null;
    }

    public boolean delete(String key) throws IOException {
        return true;
    }

    public boolean delete(BtreeKey key) throws IOException {
        return this.delete(key.toString());
    }

    protected void init() {
        int i = 0;
        while (i < this._children.length) {
            this._children[i] = -1L;
            ++i;
        }
    }

    protected void cleanTemp() {
        int i = 0;
        while (i < this._tempForPromoKey.length) {
            this._tempForPromoKey[i] = null;
            this._tempForPromoPtr[i] = -1L;
            ++i;
        }
        this._tempForPromoPtr[this._tempForPromoKey.length] = -1L;
    }

    protected int indexOf(BtreeKey key) throws BtreeManipulationException {
        int i = 0;
        while (i < this._keyCount) {
            if (key.equals(this._keys[i].toString())) {
                return i;
            }
            ++i;
        }
        throw new BtreeManipulationException("\u6307\u5b9a\u3055\u308c\u305f\u30ad\u30fc[" + key + "]\u304c\u306a\u3044");
    }

    public long rightChildOf(BtreeKey key) throws BtreeManipulationException {
        return this._children[this.indexOf(key) + 1];
    }

    public long leftChildOf(BtreeKey key) throws BtreeManipulationException {
        return this._children[this.indexOf(key)];
    }

    public byte[] getByteStream() throws BtreeException {
        int keyByteSize = this._factory.keyByteSize();
        int pageByteSize = keyByteSize * this._order + 8 * (this._order + 1) + 4;
        byte[] buffer = new byte[pageByteSize];
        ByteBuffer bf = ByteBuffer.allocate(pageByteSize).order(ByteOrder.BIG_ENDIAN);
        ((Buffer)bf).rewind();
        if (this.isEnabled()) {
            bf.putInt(this._keyCount);
        } else {
            bf.putInt(-1);
        }
        byte[] emptyKey = new byte[keyByteSize];
        int i = 0;
        while (i < this._keys.length) {
            if (this._keys[i] != null) {
                bf.put(this._keys[i].byteStream());
            } else {
                bf.put(emptyKey);
            }
            ++i;
        }
        int j = 0;
        while (j < this._children.length) {
            bf.putLong(this._children[j]);
            ++j;
        }
        byte[] ba = bf.array();
        try {
            System.arraycopy(ba, 0, buffer, 0, ba.length);
        }
        catch (Exception e) {
            throw new BtreeException(e.getMessage());
        }
        return buffer;
    }

    protected void byteStreamToBtreePage(byte[] stream, int keyByteSize) throws BtreeException {
        int pageStreamSize = keyByteSize * this._order + 8 * (this._order + 1) + 4;
        if (pageStreamSize != stream.length) {
            throw new BtreeException("\u30d0\u30a4\u30c8\u5217\u30c7\u30fc\u30bf\u306e\u9577\u3055\u3068\u30da\u30fc\u30b8\u306e\u8a2d\u5b9a\u5024\u304c\u9055\u3046");
        }
        try {
            ByteBuffer buffer = ByteBuffer.allocate(pageStreamSize).order(ByteOrder.BIG_ENDIAN);
            ((Buffer)buffer).rewind();
            buffer.put(stream);
            ((Buffer)buffer).rewind();
            this._keyCount = buffer.getInt();
            if (this._keyCount == -1) {
                this._keyCount = 0;
                this._pageno = -1L;
                this.setEnabled(false);
                return;
            }
            byte[] keyBuffer = new byte[keyByteSize];
            int i = 0;
            while (i < this._keys.length) {
                buffer.get(keyBuffer);
                this._keys[i] = this._factory.newKey(keyBuffer);
                ++i;
            }
            int j = 0;
            while (j < this._children.length) {
                this._children[j] = buffer.getLong();
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BtreeException("\u30da\u30fc\u30b8\u306e\u5fa9\u5143\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean status) {
        this.enabled = status;
    }

    public class PromoResult {
        final BtreeKey _promoKey;
        final BtreePage _page;

        PromoResult(BtreeKey pk, BtreePage bp) {
            this._promoKey = pk;
            this._page = bp;
        }
    }
}

