/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RoutingAlgorithmTestDriver.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.model;

import java.util.Iterator;
import java.util.Random;

import org.logical_paradox.testsite.oln.object.Node;
import org.logical_paradox.testsite.oln.object.Topology;

import junit.framework.TestCase;

/**
 * oH菈̃eXgphCo
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class RoutingAlgorithmTestDriver extends TestCase {
	/** ős */
	public static final int MAX_EXECUTE_COUNT = 3;
	/** Ulbg[N̋ԕ() */
	public static final int NETWORK_WIDTH = 640;
	/** Ulbg[N̋ԕ(c) */
	public static final int NETWORK_HEIGHT = 480;
	public static final int MAX_DEPLOY_COUNT = 50;
	public static final int MAX_CONNECTIONS = 25;

	/** WFl[^ */
	private final Random r = new Random(System.currentTimeMillis());

	/**
	 * Constructor for RoutingAlgorithmTestDriver.
	 * @param arg0
	 */
	public RoutingAlgorithmTestDriver(String arg0) {
		super(arg0);
	}

	/**
	 * eXghCo001
	 * _Ƀm[hǉāAg|Wێ邱ƂmF
	 */
	public void testExecuteSimulation001() {
		Topology topology = new Topology();

		// Kȉ񐔌JԂs
		int executeCount = Math.abs(r.nextInt()) % MAX_EXECUTE_COUNT;

		// 蕡Gȃlbg[N쐬
		while(executeCount >= 0) {
			createTopology(topology);
			executeCount--;
		}

		System.out.println("[001] G= " + topology.getComplex() + " ŏ=" + topology.getMinNodeCount() + " ő= " + topology.getMaxNodeCount());
		// ŏIIɁCKg|WێĂȂ΂ȂȂ
		assertTrue(topology.getNodeListSize() > 1);
		assertTrue(topology.isCompleteConnectivity());
	}
	/**
	 * eXghCo002
	 * _Ƀm[hǉA_Ƀm[h𗣒EB
	 * ̏ꍇɃg|WێAQƂĂȂƂmF
	 */
	public void testExecuteSimulation002() {
		Topology t = new Topology();
		createTopology(t);

		assertTrue(t.getNodeListSize() > 0);
		System.out.println("[00*] G= " + t.getComplex() + " ŏ=" + t.getMinNodeCount() + " ő= " + t.getMaxNodeCount());
		assertTrue(t.isCompleteConnectivity());

		// KɃm[h폜
		int executeCount = Math.abs(r.nextInt() % 50 + 10);
		while(executeCount > 0 && t.getNodeListSize() > 0) {
			int ni = Math.abs(r.nextInt() % t.getNodeListSize());
			t.removeNode(t.getNode(ni));
			System.out.println("[002] G= " + t.getComplex() + " ŏ=" + t.getMinNodeCount() + " ő= " + t.getMaxNodeCount());

			// SẴm[hݎQƂɂȂĂ邩ǂmF
			for(Iterator it = t.iteratorNodes(); it.hasNext();) {
				Node node = (Node)it.next();
				assertTrue(node.isHoldByBuddies());
			}
			assertTrue(t.getNodeListSize() <= 1 || t.isCompleteConnectivity());
			executeCount--;
		}
	}
	/**
	 * KɃm[hzuꂽUlbg[N쐬
	 * @param topology Ulbg[N
	 */
	protected void createTopology(Topology topology) {
		// Ulbg[NɓKɃm[hzu
		int deployCount = Math.abs(r.nextInt()) % MAX_DEPLOY_COUNT + 15;
		while(deployCount > 0) {
			// ɕUlbg[NɔzuĂm[h
			// KȐIĂ
			if(topology.getNodeListSize() > 0) {
				int chooseItems = Math.abs(r.nextInt() % topology.getNodeListSize() +1);
				// Ulbg[NɏȂƂ1ȏ̃m[hzuĂ̂Ȃ
				while(chooseItems > 0) {
					int index = Math.abs(r.nextInt() % topology.getNodeListSize());
					topology.get(index).setSelected(true);
					chooseItems--;
				}
			}
			int x = Math.abs(r.nextInt()) % NETWORK_WIDTH;
			int y = Math.abs(r.nextInt()) % NETWORK_HEIGHT;
			topology.deployNewNode(x,y);

			deployCount--;
		}
		// Ulbg[NCœKm[hIs
		topology.researchConnectivity();
	}
}
