/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: NetworkViewPanel.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.view;

import java.awt.BorderLayout;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JPanel;

import org.logical_paradox.testsite.oln.model.handler.NetViewCanvasMouseListener;
import org.logical_paradox.testsite.oln.model.handler.NotifyConfigureBtnListener;
import org.logical_paradox.testsite.oln.object.AppContext;
import org.logical_paradox.testsite.oln.object.RequestContext;

/**
 * lbg[Nr[t[
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class NetworkViewPanel extends JPanel {
	/** AvP[VReLXg */
	private final AppContext context_;

	/** œKm[hIsʒm{^ */
	private JButton doNotifyConfigure;

	/**
	 * RXgN^
	 * @param context AvP[VReLXg
	 */
	private NetworkViewPanel(AppContext context) {
		context_ = context;
	}
	/**
	 * AvP[VReLXgԂ
	 * @return AvP[VReLXg
	 */
	protected AppContext getAppContext() {
		return context_;
	}
	/**
	 * lbg[Nr[t[
	 * @param topo g|W[
	 * @throws Exception ɔO
	 */
	public static final NetworkViewPanel init(AppContext context) throws Exception {
		NetworkViewPanel panel = new NetworkViewPanel(context);
		panel.setLayout(new BorderLayout());
		// LoX
		NetworkViewCanvas canvas = new NetworkViewCanvas(context);
		NetViewCanvasMouseListener mouseListener = new NetViewCanvasMouseListener(context, new RequestContext());
		canvas.addMouseMotionListener(mouseListener);
		canvas.addMouseListener(mouseListener);
		panel.add(canvas, BorderLayout.CENTER);

		// pl
		JPanel controlPanel = new JPanel();
		controlPanel.setLayout(new GridLayout(1,2));

		// m[h\̈
		controlPanel.add(new NodeInfoPanel(context));
		// œKm[hIs{^
		panel.doNotifyConfigure = new JButton("Notify configure");
		NotifyConfigureBtnListener notifyButtonListener = new NotifyConfigureBtnListener(context, new RequestContext());
		panel.doNotifyConfigure.addActionListener(notifyButtonListener);
		controlPanel.add(panel.doNotifyConfigure);

		panel.add(controlPanel, BorderLayout.SOUTH);
		return panel;
	}
}
