/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: NetworkViewCanvas.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.view;

import java.awt.Color;
import java.awt.Graphics;

import javax.swing.JComponent;

import org.logical_paradox.testsite.oln.OverlayNetworkConstant;
import org.logical_paradox.testsite.oln.model.TopologyDrawerFactory;
import org.logical_paradox.testsite.oln.object.AppContext;

/**
 * lbg[Nr[\LoX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class NetworkViewCanvas extends JComponent {
	/** g|W[ */
	private final AppContext context_;
	/** g|W[`惍WbN */
	private final TopologyDrawer drawer = TopologyDrawerFactory.getDrawer();

	/**
	 * RXgN^
	 * @param context AvP[VReLXg
	 */
	public NetworkViewCanvas(AppContext context) {
		context_ = context;
	}
	/**
	 * g|W`悷
	 * @param g `ΏۃIuWFNg
	 */
	public void paint(Graphics g) {
		super.paint(g);

		Color prevColor = g.getColor();
		// wiF̃yCg
		g.setColor(OverlayNetworkConstant.DEFAULT_BG_COLOR);
		g.fillRect(0, 0, getWidth(), getHeight());

		// lbg[N`悷
		drawer.paint(g, context_.getTopology());
		
		// uV̐Fɖ߂
		g.setColor(prevColor);
	}
}
