/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: DefaultTopologyDrawer.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;

import org.logical_paradox.testsite.oln.OverlayNetworkConstant;
import org.logical_paradox.testsite.oln.object.Node;
import org.logical_paradox.testsite.oln.object.Topology;

/**
 * ftHg̃g|W[`惍WbN
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class DefaultTopologyDrawer implements TopologyDrawer {
	/**
	 * g|W[`悷
	 * @param g `Ώۃ[W
	 * @param topo `悷g|W[
	 */
	public void paint(Graphics g, Topology topo) {
		// uV̐ݒ
		Color prevColor = g.getColor();

		for(Iterator it = topo.iteratorNodes(); it.hasNext();) {
			Node node = (Node)it.next();
			Rectangle rect = node.getRectangle();

			// m[h̕`Ώۗ̈xwiFœhԂ
			g.setColor(OverlayNetworkConstant.DEFAULT_BG_COLOR);
			g.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());

			if(node.isSelected()) {
				g.setColor(Color.BLUE);
			} else {
				g.setColor(Color.GREEN);
			}

			if(node.isMarked() == false) {
				// }[NĂȂm[h̏ꍇ(}EXɂȂꍇ)
				g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
			} else {
				// }[Nς݃m[h̏ꍇ(}EXɂꍇ)
				Rectangle selectableRect = node.getSelectableRectangle();
				g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
				g.setColor(Color.RED);
				g.drawRect((int)selectableRect.getX(), (int)selectableRect.getY(), (int)selectableRect.getWidth(), (int)selectableRect.getHeight());
			}

			// ֘Am[hɑ΂āAN͂
			if(topo.isCompleteConnectivity()) {
				g.setColor(Color.CYAN);
			} else {
				g.setColor(Color.YELLOW);
			}
			for(Iterator it2 = node.iteratorRelativeNodes(); it2.hasNext();) {
				Node pair = (Node)it2.next();
				g.drawLine((int)node.getX(), (int)node.getY(), (int)pair.getX(), (int)pair.getY());
			}

			node.unmark();
		}
		// uVɖ߂
		g.setColor(prevColor);
	}
}
