/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: NetViewCanvasMouseListener.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.model.handler;

import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;

import org.logical_paradox.testsite.oln.OverlayNetworkConstant;
import org.logical_paradox.testsite.oln.object.AppContext;
import org.logical_paradox.testsite.oln.object.Node;
import org.logical_paradox.testsite.oln.object.RequestContext;
import org.logical_paradox.testsite.oln.view.MainWndGeneralPopupMenu;
import org.logical_paradox.testsite.oln.view.NodePropertyPopupMenu;

/**
 * g|W[r[Ŕ}EX֘ACxgnhOCxgnh
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class NetViewCanvasMouseListener extends AbstractOlnListenerAdapter implements MouseInputListener {
	/**
	 * }EXvXꂽۂɑIꂽm[h
	 */
	private Node lastSelectedNode;

	/**
	 * RXgN^
	 * @param context AvP[VReLXg
	 * @param request NGXgReLXg
	 */
	public NetViewCanvasMouseListener(AppContext context, RequestContext request) {
		super(context, request);
	}
	/**
	 * }EX̃{^NbNꂽۂ̃Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void mouseClicked(MouseEvent e) {
		if(e.getButton() == MouseEvent.BUTTON1) {
			// NbN̏ꍇ
			doLeftButtonClicked(e);
		}
	}
	public void mouseEntered(MouseEvent e) {
	}
	public void mouseExited(MouseEvent e) {
	}
	/**
	 * }EXꂽۂ̃Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void mousePressed(MouseEvent e) {
		if(e.getButton() == MouseEvent.BUTTON1) {
			// E{^ꂽۂɁA}EX̉ɂm[hIĂ
			// D&DȂǂŕKv
			lastSelectedNode = getAppContext().getTopology().getNode(e.getPoint());
		}
	}
	/**
	 * }EX̃{^ꂽۂ̃Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void mouseReleased(MouseEvent e) {
		lastSelectedNode = null;
		if(e.isPopupTrigger()) {
			// ENbNCxg
			doRightButtonClicked(e);
		}
	}
	/**
	 * hbOۂ̃Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void mouseDragged(MouseEvent e) {
		if(lastSelectedNode != null) {
			lastSelectedNode.move(e.getPoint());
			getAppContext().getFrame().repaint();
		}
	}
	/**
	 * }EXړۂ̃Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void mouseMoved(MouseEvent e) {
		Node node = getAppContext().getTopology().getNode(e.getPoint());
		if(node != null) {
			node.mark();
		}
		getAppContext().getFrame().repaint();
	}
	/**
	 * NbNCxg
	 * NbNʒuɉ炩̃m[h݂ꍇ́AYm[hIԂƂ
	 * m[hȂꍇAIԂ
	 * @param e CxgIuWFNg
	 */
	protected void doLeftButtonClicked(MouseEvent e) {
		Node node = getAppContext().getTopology().getNode(e.getPoint());
		if(node != null) {
			node.setSelected(true);
		} else {
			// SẴm[h̑I
			getAppContext().getTopology().deSelectAll();
		}
		// ʍĕ`
		getAppContext().getFrame().repaint();
	}
	/**
	 * ENbNCxg
	 * ݂̃J[\ʒuɃm[h݂Ȃꍇ́A|bvAbv_CAO\
	 * ݂̃J[\ʒuɉ炩̃m[h݂ꍇ́AvpeB̃_CAO\
	 * @param e CxgIuWFNg
	 */
	protected void doRightButtonClicked(MouseEvent e) {
		Node node = getAppContext().getTopology().getNode(e.getPoint());
		JPopupMenu menu = null;
		RequestContext request = new RequestContext();
		request.setAttribute(OverlayNetworkConstant.RKEY_MOUSE_CLICKED_POS_X, new Integer(e.getX()));
		request.setAttribute(OverlayNetworkConstant.RKEY_MOUSE_CLICKED_POS_Y, new Integer(e.getY()));

		if(node != null) {
			// }EXJ[\̉Ƀm[h݂ꍇ
			menu = new NodePropertyPopupMenu(getAppContext(), request, node);
		} else {
			// }EXJ[\̉Ƀm[h݂Ȃꍇ
			menu = new MainWndGeneralPopupMenu(getAppContext(), request);
		}
		// |bvAbvj[̕\
		menu.show(e.getComponent(), e.getX(), e.getY());
	}
}
