/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: DefaultRoutingAlgorithm.java,v 1.3 2005/03/18 13:55:26 rampil Exp $
 */
package org.logical_paradox.testsite.oln.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.logical_paradox.testsite.oln.object.Metric;
import org.logical_paradox.testsite.oln.object.Node;

/**
 * ftHg̃[eBOASY
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class DefaultRoutingAlgorithm extends RoutingAlgorithm {
	/** œKm[hI̋Ȑ̌X */
	public static final double SLOPE_OF_CURVE = 1.125;
	/** m[hXgƂĕێœKm[h */
	public static final int MAX_FETCH_COUNT = 15;
	/** T̐[x */
	public static final int MAX_SEARCH_DEPTH = 2;

	/**
	 * RXgN^
	 * @param node m[h
	 */
	protected DefaultRoutingAlgorithm(Node node) {
		super(node);
	}

	/**
	 * œKm[hIs
	 */
	public void configure() {
		// ݕRÂĂm[hAKȐ[x̃m[hXg擾ăm[hXg\
		HashSet collectedNodeList = collectNodeList(getNode().getRelativeNodes(), MAX_SEARCH_DEPTH);
		// HUGv𔭍s(͖̏ʂɃgtBbN𔭐̂ŁAۂɂhugȂ@l邱)
		for(Iterator it = collectedNodeList.iterator(); it.hasNext();) {
			Node node = (Node)it.next();
			if(getNode().equals(node) == false && getNode().contains(node) == false) {
				node.hug(getNode());
				getNode().add(node);
			}
		}
		ArrayList metrics = new ArrayList();
		for(Iterator it = getNode().iteratorRelativeNodes(); it.hasNext();) {
			Node n = (Node)it.next();
			metrics.add(new Metric(getNode().distanceFrom(n), n));
		}

		// gbNl̏(߂̏)Ƀ\[g
		Collections.sort(metrics);
		int fetchPoint = 0;
		int fetchCount = 0;
		ArrayList bestNodes = new ArrayList();

		for(;;) {
			fetchPoint = (int)Math.pow((double)fetchCount, SLOPE_OF_CURVE);
			fetchCount++;

			if(fetchPoint >= metrics.size()) {
				break;
			}
			Metric m = (Metric)metrics.get(fetchPoint);
			if(bestNodes.contains(m)) {
				// Im[h͊ɍœKm[hƂđIς݂
				continue;
			} else {
				// œKm[hƂđI
				bestNodes.add(m.getBuddy());
			}
			if(bestNodes.size() >= MAX_FETCH_COUNT) {
				break;
			}
		}

		if(bestNodes.size() > 0) {
			// œKm[hIꂽ̂Sč폜
			getNode().getRelativeNodes().removeAll(bestNodes);		
			// cm[h(=Nؒfm[h)ɑ΂āAEʒm
			notifyDisconnect();
			// œKm[ĥ݂̃XgŃNč\
			getNode().addAll(bestNodes);
		}
	}

	/**
	 * ̃m[hƌqĂ鑼̃m[hm[hXgW
	 * w肳ꂽKwJԂs
	 * [DTŎs
	 * @param depth T̐[(1ȏ)
	 * @return Wꂽm[hXg(dƎ̃m[h܂܂Ȃ)
	 */
	protected HashSet collectNodeList(List nodeList, int depth) {
		HashSet nodes = new HashSet();

		if(depth > 0) {
			// Ƃēnꂽm[hɂāCm[hXgv
			for(Iterator it = nodeList.iterator(); it.hasNext();) {
				Node node = (Node)it.next();
				// m[hXgǉ
				nodes.addAll(node.getRelativeNodes());
				// ̊KwTʂǉ
				nodes.addAll(collectNodeList(node.getRelativeNodes(), depth-1));
			}
		}
		return nodes;
	}

	/**
	 * hug
	 * @param node hugvĂm[h
	 * @return true: / false:
	 */
	public boolean hug(Node node) {
		if(getNode().contains(node) == false) {
			getNode().add(node);
		}
		return true;
	}

	/**
	 * hugĂSẴm[hɑ΂āCUlbg[N̗Eʒm
	 */
	public void notifyDisconnect() {
		for(Iterator it = getNode().iteratorRelativeNodes(); it.hasNext();) {
			Node node = (Node)it.next();
			// ڑ̃m[hC̃m[hɊւ郊N폜
			node.remove(getNode());
			it.remove();
		}
	}
}
