/*
 * $Id: RandomTextClient.java,v 1.2 2005/05/15 03:53:36 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 */
package org.logical_paradox.testsite.async;

import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Vector;

import org.logical_paradox.common.net.async.CAsyncClientSocket;
import org.logical_paradox.common.net.async.CAsyncSocket;
import org.logical_paradox.common.net.async.Multiplexer;
import org.logical_paradox.common.util.StringUtils;


/**
 * RandomTextClient
 * T[o[烉_ȕsĎMÂNCAgvO
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public final class RandomTextClient {
	private int maxClients = 5;								// NCAg
	private final String rts;									// T[o[
	private final Multiplexer multiplexer;					// }`vNT

	/**
	 * RXgN^
	 * @param server [gzXg
	 * @throws Exception ɎsۂɔO
	 */
	public RandomTextClient(String server) throws Exception {
		// NCAg[hŃ}`vNT𐶐
		HashMap m = new HashMap();
		m.put(Multiplexer.KEY_CLIENT_SOCKET_FACTORY, new CAsyncClientSocketFactoryImpl());
		m.put(Multiplexer.KEY_PORT_NUMBER, "" + RandomTextServer.DEFAULT_LISTENING_PORT);
		m.put(Multiplexer.KEY_REMOTE_HOST, server);
		rts = server;
		multiplexer = new Multiplexer(Multiplexer.MPX_MODE_CLIENT, m);

		// \Pbg`l
		for(int i = 0; i < maxClients; i++) {
			multiplexer.addChannel(SelectionKey.OP_CONNECT | SelectionKey.OP_READ | SelectionKey.OP_WRITE);
		}
	}

	/**
	 * T[o[ɑ΂ēKȕ𑗐MÂ
	 * @throws Exception f[^MɔO
	 */
	public void doWork() throws Exception {
		boolean loopf = true;

		while(loopf) {
			multiplexer.doWork();
			Thread.sleep(500);
			sendAll();
		}
	}
	/**
	 * T[o[ɑ΂ēKȕ𑗐M
	 * @throws Exception MɃG[
	 */
	public void sendAll() throws Exception {
		Vector clientChannels = multiplexer.getChannels(); 
		for( int i = 0; i < clientChannels.size(); i++ ) {
			CAsyncSocket casock = (CAsyncSocket)clientChannels.elementAt(i);

			// Mobt@ɑ΂āAMf[^ł
			// T[o[\PbgM\ɂȂۂɁAIɑM
			if(casock instanceof CAsyncClientSocket) {
				casock.sendMessage(StringUtils.randomText(16,true).getBytes());
			}
		}
	}
	/**
	 * C\bh
	 * @param args vO
	 * @throws Exception nhOȂO
	 */
	public static final void main(String[] args) throws Exception {
		if(args.length != 1) {
			System.err.println("usage: java org.logical_paradox.rts.client.RandomTextClient <hostname>");
			return;
		}

		final RandomTextClient rtc = new RandomTextClient(args[0]);
		rtc.doWork();
	}
}

// end of RandomTextClient.java
