/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: StringUtilsTest.java,v 1.2 2005/05/31 14:36:46 rampil Exp $
 */
package org.logical_paradox.common.util;

import junit.framework.TestCase;

/**
 * 񑀍샆[eBeB̃eXgP[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class StringUtilsTest extends TestCase {

	/**
	 * Constructor for StringUtilsTest.
	 * @param arg0
	 */
	public StringUtilsTest(String arg0) {
		super(arg0);
	}
	/**
	 * <pre>
	 * 񌟍̃eXg
	 * {ꕶ̏ꍇ
	 * </pre>
	 */
	public void testSearchWordIndexes001() {
		final String text =
			"Open-SEDḰA{bg^T[`GWĴ`鑼ɁAvO~OƂlXɑ΂āAyĎhIȃI`񋟂ړI܂B" +
			"ۂɂǂ̂悤ɂėVׂ΂悢ɂẮAiKIɗᎦĂƍlĂ܂B" +
			"I[v\[X̃vWFNgł̂ŁÂ܂܎pA邢͎pړĨT[`GWĴ͎~߂܂񂪁AuyvVłƁAJƂĂ͊v܂B";

		final String word = "܂B";

		Integer[] locations = StringUtils.searchWordIndexes(text, word);
		assertEquals(3, locations.length);
	}
	/**
	 * <pre>
	 * 񌟍̃eXg
	 * p1ŁAΏە̖vꍇ
	 * </pre>
	 */
	public void testSearchWordIndexes002() {
		final String text = "Xbs121098sdfXeqcsacCX";
		final String word = "X";

		Integer[] locations = StringUtils.searchWordIndexes(text, word);
		assertEquals(3, locations.length);

		assertEquals(0, locations[0].intValue());
		assertEquals(12, locations[1].intValue());
		assertEquals(20, locations[2].intValue());
	}
	/**
	 * <pre>
	 * V[PX̃eXg001
	 * w肳ꂽAAĕԋp
	 * </pre>
	 */
	public void testSequence001() {
		assertEquals("00000", StringUtils.sequence('0', 5));
	}
	/**
	 * <pre>
	 * V[PX̃eXg002
	 * w肳ꂽAAĕԋp
	 * </pre>
	 */
	public void testSequence002() {
		assertEquals("AAAAAA", StringUtils.sequence('A', 6));
	}
	/**
	 * <pre>
	 * tH[}bg̃eXg001
	 * </pre>
	 */
	public void testFormatColumns001() {
		assertEquals("00001", StringUtils.formatColumns(1, 5));
	}
	/**
	 * <pre>
	 * tH[}bg̃eXg002
	 * </pre>
	 */
	public void testFormatColumns002() {
		assertEquals("1234567", StringUtils.formatColumns(1234567, 7));
	}
	/**
	 * <pre>
	 * tH[}bg̃eXg003
	 * </pre>
	 */
	public void testFormatColumns003() {
		assertEquals("98765", StringUtils.formatColumns(98765, 4));
	}
}
