/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: SessionContextTest.java,v 1.1 2005/02/28 13:26:25 rampil Exp $
 */
package org.logical_paradox.common.session;

import java.util.ArrayList;
import java.util.Hashtable;

import junit.framework.TestCase;

import org.logical_paradox.common.util.AttributeChangeEvent;
import org.logical_paradox.common.util.AttributeChangeListener;

/**
 * ZbVReLXg̃eXgR[h
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class SessionContextTest extends TestCase {

	/**
	 * Constructor for SessionContextTest.
	 * @param arg0
	 */
	public SessionContextTest(String arg0) {
		super(arg0);
	}
	/**
	 * ύXʒmXi[Ȃ̏Ԃł́C̓o̓eXg
	 *
	 */
	public void testAttributeInOutWithoutListener() {
		SessionContext context = new SessionContext();

		Hashtable ht = new Hashtable();
		ArrayList al = new ArrayList();
		Long l = new Long(10000L);

		// 
		context.setAttribute("OK", ht);
		context.setAttribute("+*=-~[]", al);
		context.setAttribute("", l);

		// o̓eXg
		assertTrue(ht == context.getAttribute("OK"));
		assertTrue(al == context.getAttribute("+*=-~[]"));
		assertTrue(l == context.getAttribute(""));

		// ɓo^Ă鑮ɑ΂āCēxi[Ď
		context.setAttribute("", ht);
		assertTrue(ht == context.getAttribute(""));
	}
	/**
	 * ύXʒmXi[̏Ԃł́C̓o̓eXg
	 *
	 */
	public void testAttributeInOutWithListener() {
		AttributeChangeListenerImpl listener = new AttributeChangeListenerImpl();
		SessionContext context = new SessionContext();

		Hashtable ht = new Hashtable();
		ArrayList al = new ArrayList();
		Long l = new Long(10000L);

		// ύXʒmXi[̓o^
		context.setAttributeChangeListener("", listener);
		context.setAttributeChangeListener("OK", listener);
		// 
		context.setAttribute("OK", ht);
		assertTrue(ht == listener.getPreReason());
		assertTrue(ht == listener.getPostReason());
		assertTrue(context == listener.getPreSource());
		assertTrue(context == listener.getPostSource());
		context.setAttribute("+*=-~[]", al);
		context.setAttribute("", l);
		assertTrue(l == listener.getPreReason());
		assertTrue(context == listener.getPreSource());
		assertTrue(l == listener.getPostReason());
		assertTrue(context == listener.getPostSource());
	}

	/**
	 * ύXʒmXi[̃eXgp̎
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.1 $
	 */
	class AttributeChangeListenerImpl implements AttributeChangeListener {
		private Object preReason;
		private Object preSrc;
		private Object postReason;
		private Object postSrc;

		private boolean preChangeRan = false;
		private boolean postChangedRan = false;

		public Object getPreReason() {
			return preReason;
		}
		public Object getPreSource() {
			return preSrc;
		}
		public Object getPostReason() {
			return postReason;
		}
		public Object getPostSource() {
			return postSrc;
		}
		public boolean isPreChangeRan() {
			return preChangeRan;
		}
		public boolean isPostChangeRan() {
			return postChangedRan;
		}
		public void preChange(AttributeChangeEvent e) {
			preReason = e.getReason();
			preSrc = e.getSource();
			preChangeRan = true;
		}
		public void postChanged(AttributeChangeEvent e) {
			postReason = e.getReason();
			postSrc = e.getSource();
			postChangedRan = true;
		}
	}
}
