/**
 * $Id: MultiplexerTest.java,v 1.1 2005/05/08 03:06:59 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.net.async;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import org.logical_paradox.common.net.async.impl.CAsyncClientSocketFactoryImpl;
import org.logical_paradox.common.net.async.impl.CAsyncServerSocketFactoryImpl;

import junit.framework.TestCase;

/**
 * }`vNT̃eXgP[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class MultiplexerTest extends TestCase {

	/**
	 * Constructor for MultiplexerTest.
	 * @param arg0
	 */
	public MultiplexerTest(String arg0) {
		super(arg0);
	}
	/**
	 * T[o[\Pbg`l̒ǉeXg
	 */
	public void testAddServerChannel() throws Exception {
		HashMap m = new HashMap();
		m.put(Multiplexer.KEY_SERVER_SOCKET_FACTORY, new CAsyncServerSocketFactoryImpl());
		m.put(Multiplexer.KEY_CLIENT_SOCKET_FACTORY, new CAsyncClientSocketFactoryImpl());
		m.put(Multiplexer.KEY_PORT_NUMBER, "1234");
		m.put(Multiplexer.KEY_REMOTE_HOST, "localhost");
		StubMultiplexer mpx = new StubMultiplexer(Multiplexer.MPX_MODE_SERVER, m);

		mpx.addChannel(SelectionKey.OP_ACCEPT);

		// T[o[\Pbg`lo^Ă邩
		assertEquals(1, mpx.getChannels().size());
		// ꂽCX^XCAsyncServerSocket̃TuNXǂ
		assertTrue(mpx.getChannels().get(0) instanceof CAsyncServerSocket);
	}
	/**
	 * }`vNT̃eXgpX^u
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.1 $
	 */
	class StubMultiplexer extends Multiplexer {
		/**
		 * RXgN^
		 * @param mode
		 * @param m
		 * @throws IOException
		 */
		public StubMultiplexer(int mode, Map m) throws IOException {
			super(mode, m);
		}
		public Vector getChannels() {
			return super.getChannels();
		}

	}
}
