/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.util;

import java.util.Iterator;

/**
 * D揇ʂLbV
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class PriorityCache extends Cache {
	public static final int GREATER_FIRST = 1;
	public static final int LESS_FIRST = 0;

	private final int sortOrder;

	/**
	 * ftHgRXgN^
	 * LbVAEgȂݒŏ
	 */
	public PriorityCache() {
		super();
		sortOrder = GREATER_FIRST;
	}
	/**
	 * RXgN^
	 * w肳ꂽLbVTCY𒴂ꍇCÂ̂LbVAEgD<br>
	 * size0w肵ꍇCLbVAEgȂ
	 *
	 * @param size TCY
	 */
	public PriorityCache(int size) {
		super(size);
		sortOrder = GREATER_FIRST;
	}
	/**
	 * RXgN^
	 * w肳ꂽLbVTCY𒴂ꍇCÂ̂LbVAEgD<br>
	 * size0w肵ꍇCLbVAEgȂ
	 * 
	 * @param size TCY
	 * @param order \[gI[_[(GREATER_FIRST: 傫قD LESS_FIRST: قD)
	 */
	public PriorityCache(int size, int order) {
		super(size);
		sortOrder = order;
	}
	/**
	 * LbVɃIuWFNgǉ
	 * LbVTCY𒴂ꍇCÓȃLbVhIuWFNgLbVAEg
	 * 
	 * @param o ǉIuWFNg
	 * @return LbVAEgIuWFNg(null: Ȃ)
	 */
	public Object add(Object o) {
		return add((Comparable)o);
	}
	/**
	 * LbVɃIuWFNgǉ
	 * LbVTCY𒴂ꍇCÓȃLbVhIuWFNgLbVAEg
	 * 
	 * @param o ǉIuWFNg
	 * @return LbVAEgIuWFNg(null: Ȃ)
	 */
	public Object add(Comparable o) {
		Object rc = null;
		synchronized(collection) {
			if(collection.size() == limit) {
				rc = cacheOut();
			}
			// }\ʒu擾
			int idx = findInsertableIndex(o);
			if(idx == -1) {
				// ʂɍŌɒǉ
				collection.add(o);
			} else {
				// rɑ}
				collection.add(idx, o);
			}
		}
		return rc;
	}
	/**
	 * }\ȃCfbNXԂ
	 * 
	 * @param o }IuWFNg
	 * @return }ʒu(-1: Ō)
	 */
	protected int findInsertableIndex(Comparable o) {
		// sequential searchȒT@
		int idx = 0;
		synchronized(this) {
			for(Iterator it = collection.iterator(); it.hasNext(); idx++) {
				switch(sortOrder) {
					case GREATER_FIRST:
						// ^ꂽIuWFNĝقƂƂ̂̂傫ꍇ
						if(o.compareTo((Comparable)it.next()) > 0) {
							return idx;
						}
						break;
					case LESS_FIRST:
						// ^ꂽIuWFNĝقƂƂ̂̂菬ꍇ
						if(o.compareTo((Comparable)it.next()) < 0) {
							return idx;
						}
						break;
					default:
						throw new IllegalArgumentException("ݒ肳ĂD揇ʃI[_[:" + sortOrder);
				}
			}
		}
		// Ō܂ő}\ȈʒuȂ
		return -1;
	}
}
