/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

/**
 * bZ[W_CWFXg𐶐郆[eBeB
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Digester {
	/** T|[gĂASY - MD5 */
	public static final String MD5 = "md5";
	/** T|[gĂASY - SHA1 */
	public static final String SHA1 = "sha1";

	/** ASY */
	private final String algorithm;
	/** _CWFX^[̃CX^Xi[}bv */
	private static final HashMap digesters = new HashMap();

	/**
	 * RXgN^
	 * @param algo ASY
	 */
	private Digester(String algo) {
		algorithm = algo;
	}
	/**
	 * _CWFX^[̃CX^XԂ
	 * @param algo ASY
	 * @return _CWFX^[(ɑ݂ꍇ͍ėp)
	 */
	public static final Digester getInstance(String algo) {
		synchronized(digesters) {
			Digester d = (Digester)digesters.get(algo);
			if(d == null) {
				d = new Digester(algo);
				digesters.put(algo, d);
			}
			return d;
		}
	}
	/**
	 * _CWFXg𐶐
	 * @param ̃bZ[W
	 * @return ꂽnbVl
	 */
	public String getDigest(String msg) {
		try {
			// MD5bZ[W_CWFXg
			MessageDigest md = MessageDigest.getInstance(algorithm);
			md.update(msg.getBytes());
			byte[] digestData = md.digest();

			/*
			 * w肳ꂽoCgɕϊāC128bit16iɕϊ
			 */
			StringBuffer sb = new StringBuffer();
			for(int i = 0; i < digestData.length; i++) {
				int b = digestData[i] >= 0 ? digestData[i] : digestData[i] + 256;
				if(b < 0x10) {
					sb.append("0");
				}
				sb.append(Integer.toString(b, 16));
			}
			
			return sb.toString();
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
			return null;
		}
	}
}
