/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: CAsyncServerSocket.java,v 1.5 2005/05/04 07:49:56 rampil Exp $
 */
package org.logical_paradox.common.net.async;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;

/**
 * CAsyncServerSocket
 * 񓯊T[o[\Pbg
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public abstract class CAsyncServerSocket extends CAsyncSocket {
	/** T[o[\Pbg̏ */
	private boolean listening = false;
	/** listenĂ|[gԍ */
	private final int port_;

	/**
	 * RXgN^
	 * @param port |[gԍ
	 * @throws IOException T[o[\Pbg̐Ɏs
	 */
	public CAsyncServerSocket(int port) throws IOException {
		port_ = port;
		channel = (SelectableChannel)ServerSocketChannel.open();
		((ServerSocketChannel)channel).socket().bind(new InetSocketAddress(port), 512);
	}
	/**
	 * T[o[\PbglisteningĂԂǂԂ
	 * @return true: ܂Ă / false: closeꂽ
	 */
	public boolean isListening() {
		return listening;
	}
	/**
	 * T[o[\Pbg`lN[Y
	 * @throws IOException N[YɎs
	 */
	public void close() throws IOException {
		if(listening == true) {
			((ServerSocketChannel)channel).socket().close();
			listening = false;
		}
	}
	/**
	 * listenĂ|[gԍԂ
	 * @return |[gԍ
	 */
	public int getPort() {
		return port_;
	}
	/**
	 * NCAgT[o[ɐڑꍇɔCxg̃nh
	 * @param e 񓯊Cxg
	 */
	public void onConnect(AsyncEvent e) {
	}
	/**
	 * ڑ肩牽̃f[^MۂɔCxg̃nh
	 * @param e 񓯊Cxg
	 */
	public abstract void onReceive(AsyncEvent e);
	/**
	 * ڑɉ̃f[^𑗐MۂɔCxg̃nh
	 * @param e 񓯊Cxg
	 */
	public void onSend(AsyncEvent e) {
		super.onSend(e);
	}
	/**
	 * NCAg̐ڑ󂯕tۂɔCxg̃nh
	 * @param e 񓯊Cxg
	 */
	public abstract void onAccept(AsyncEvent e);
}

// end of CAsyncServerSocket.java
