/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 */
package org.logical_paradox.common.lang;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import org.logical_paradox.common.io.ByteStream;

/**
 * oCg񉻉\Integerbp[
 * oCg񉻂ꍇCIntegerBIG_ENDIANŊi[
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class IntegerByteStream implements ByteStream {
	private final Integer value;
	private final byte[] bstream;

	/**
	 * RXgN^
	 * @param l lIuWFNg
	 */	
	public IntegerByteStream(Integer l) {
		value = l;
		bstream = objectToByteStream(l.intValue());
	}
	/**
	 * RXgN^
	 * @param l l
	 */
	public IntegerByteStream(int l) {
		this(new Integer(l));
	}
	/**
	 * Integer^̃IuWFNgԂ
	 * @return lIuWFNg
	 */
	public Integer getIntegerObject() {
		return value;
	}
	/**
	 * intlԂ
	 * @return l
	 */
	public long intValue() {
		return value.intValue();
	}
	/**
	 * ̃IuWFNgoCgɕϊĕԂ
	 * oCgւ̕ΐCRXgN^ĂяoɍsĂ̂ŁC
	 * ł͒PɂԂ
	 * @return oCg
	 */
	public byte[] byteStream() {
		return bstream;
	}
	/**
	 * lIuWFNgoCg֕ϊĕԂ
	 * @param l l
	 * @return oCg
	 */
	protected byte[] objectToByteStream(int l) {
		ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
		buffer.rewind();
		buffer.putInt(l);
		
		return buffer.array();
	}
}

// end of IntegerByteStream.java
