/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import org.logical_paradox.common.util.Cache;

/**
 * p\Xgt@CɓeNX
 * Xg̊Ǘorg.logical_paradox.common.util.CacheōsȂ
 * Ԃ̊ǗꍇCJX^ꂽCachegp悤
 * hNXŎ
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public abstract class AvailableList {
	protected final String filename;
	protected final Cache cache;

	/**
	 * RXgN^
	 * @param filename t@C
	 */
	public AvailableList(String filename) {
		this(filename, 0);
	}
	/**
	 * RXgN^
	 * @param filename t@C
	 * @param size tOgRNṼTCY
	 */
	public AvailableList(String filename, int size) {
		this.filename = filename;
		cache = createCache(size);

		// fЉt@CɃ[h
		try {
			reload();
		} catch(IOException ioe) {
			// fЉt@Ĉ݂Ȃ̂Ŗ
		}
	}
	/**
	 * ̗p\XgŎgpLbVIuWFNg𐶐
	 * @param size
	 * @return
	 */
	protected Cache createCache(int size) {
		return new Cache(size);
	}
	/**
	 * p\Xgt@CǂݍŁCSɍXV
	 * @throws IOException t@CANZXɎs
	 */
	public void reload() throws IOException {
		byte[] buf = new byte[(int)getFileSize()];
		InputStream in = getInputStream();
		in.read(buf);
		in.close();

		ByteBuffer buffer = ByteBuffer.allocate(buf.length).order(ByteOrder.BIG_ENDIAN);
		buffer.rewind();
		buffer.put(buf);
		buffer.rewind();
		restore(buffer);
	}
	/**
	 * oCg񂩂痘p\Xg𕜌鏈
	 * @param buffer oCg
	 * @throws IOException ɗO
	 */
	protected abstract void restore(ByteBuffer buffer) throws IOException;

	/**
	 * ɃLbVĂfЉt@Cɏo͂
	 * @throws IOException t@CANZXɎs
	 */
	public abstract void flush() throws IOException;

	/**
	 * fЉR[hLbVԂ
	 * 
	 * @return LbV
	 */
	public Cache getCache() {
		return cache;
	}
	//-----------------------------------------------------------------------
	// t@CȊÕf[^\[XgpꍇCȍ~I[o[Ch
	//-----------------------------------------------------------------------
	/**
	 * t@CANZXɕKvȓ̓Xg[Ԃ
	 * Kt@C̐擪|CgĂ
	 * @return ̓Xg[
	 * @throws IOException I[vɎs
	 */	
	protected InputStream getInputStream() throws IOException {
		return new BufferedInputStream(new FileInputStream(filename));
	}
	/**
	 * t@CANZXɕKvȏo̓Xg[Ԃ
	 * Kt@C̐擪|CgĂD܂C̃\bhĂԂƊ̃t@C͔jD
	 * @return o̓Xg[
	 * @throws IOException I[vɎs
	 */
	protected OutputStream getOutputStream() throws IOException {
		return new BufferedOutputStream(new FileOutputStream(filename));
	}
	/**
	 * fЉt@C̃t@CTCYԂ
	 * @return t@CTCY
	 * @throws IOException fЉt@CɃANZXłȂ
	 */
	protected long getFileSize() throws IOException {
		return new File(filename).length();
	}
}
