/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ClientRequestTest.java,v 1.1 2005/05/11 17:48:29 rampil Exp $
 */
package org.logical_paradox.httpd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.logical_paradox.httpd.exception.HttpException;
import org.logical_paradox.httpd.exception.IllegalConfigException;

import junit.framework.TestCase;

/**
 * ClientRequestNX̃eXgP[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ClientRequestTest extends TestCase {
	/**
	 * Constructor for ClientRequestTest.
	 * @param arg0
	 */
	public ClientRequestTest(String arg0) {
		super(arg0);
	}
	/**
	 * vgRo[WwȂ̏ꍇHTTP/1.0̃NGXg()
	 */
	public void testHttp10RequestWithoutProtocolVersion() throws HttpException, IllegalConfigException {
		final String rq = "GET /index.jsp\r\n\r\n";
		ClientRequest cr = new ClientRequest(rq, new Config(new String[0]));
		// {p[^̌
		checkBasicParameters(new String[]{"GET","/index.jsp","HTTP","1.0"}, cr);
	}
	/**
	 * vgRo[Ww肠̏ꍇHTTP/1.0̃NGXg()
	 */
	public void testHttp10Request() throws HttpException, IllegalConfigException {
		final String rq = "HEAD /index.jsp?command=ModifyThreadTree&thread_no=ab11220011   FTP/2.5\r\n\r\n";
		ClientRequest cr = new ClientRequest(rq, new Config(new String[0]));
		// {p[^̌
		checkBasicParameters(new String[]{"HEAD","/index.jsp?command=ModifyThreadTree&thread_no=ab11220011","FTP","2.5"}, cr);
	}
	/**
	 * sȃNGXgwb_`̃eXg
	 */
	public void testIllegalRequestHeaderFormat() throws IllegalConfigException {
		try {
			final String rq1 = "HEAD /index.jsp?command=ModifyThreadTree &thread_no=ab11220011   FTP/2.5\r\n\r\n";
			new ClientRequest(rq1, new Config(new String[0]));
			fail();
		} catch (HttpException e) {
			// tH[}bgG[ôŐ
		}
		try {
			final String rq1 = "\r\n\r\n";
			new ClientRequest(rq1, new Config(new String[0]));
			fail();
		} catch (HttpException e) {
			// tH[}bgG[ôŐ
		}
		try {
			final String rq1 = "HEAD \r\n\r\n";
			new ClientRequest(rq1, new Config(new String[0]));
			fail();
		} catch (HttpException e) {
			// tH[}bgG[ôŐ
		}
	}
	/**
	 * wb_̃eXg
	 */
	public void testCorrectedHeaders() throws HttpException, IllegalConfigException {
		final String rq1 =
				"get /index.php?command=MonitorSystemStatus&statcd=OK HTTP/1.1\r\n" +
				"Host: localhost.localdomain\r\n" +
				"User-Agent: Mozilla 4.0(ja)\r\n" +
				"X-Blank-Header:\r\n" +
				"\r\n";
		ClientRequest cr = new ClientRequest(rq1, new Config(new String[0]));

		// mFp}bv
		HashMap m = new HashMap();
		m.put("Host", "localhost.localdomain");
		m.put("User-Agent", "Mozilla 4.0(ja)");
		m.put("X-Blank-Header","");
		checkHeaders(m, cr);
	}
	/**
	 * sȃwb_̃eXg
	 * @throws BadRequestException
	 */
	public void testInCorrectHeaders() throws HttpException, IllegalConfigException {
		final String rq1 =
				"get /index.php?command=MonitorSystemStatus&statcd=OK HTTP/1.1\r\n" +
				"Host: localhost.localdomain\r\n" +
				"User-Agent = Mozilla 4.0(ja)\r\n" +
				"X-Blank-Header:\r\n" +
				"\r\n";
		ClientRequest cr = new ClientRequest(rq1, new Config(new String[0]));
		// mFp}bv
		HashMap m = new HashMap();
		m.put("Host", "localhost.localdomain");
		m.put("X-Blank-Header","");
		checkHeaders(m, cr);

		// sȃwb_͊i[ĂȂ͂
		assertNull(cr.getHeaderValue("User-Agent"));
	}
	/**
	 * NGXgp[^({)ɂăeXg
	 * @param values l(\bh, NG[, vgR, o[W̕)
	 * @param cr NGXgp[^
	 */
	protected void checkBasicParameters(String[] values, ClientRequest cr) {
		// \bh
		assertEquals(values[0], cr.getMethod());
		// NG[
		assertEquals(values[1], cr.getQuery());
		// vgR
		assertEquals(values[2], cr.getProtocol());
		// o[W
		assertEquals(values[3], cr.getVersion());
	}
	/**
	 * ̃wb_̐ݒlŐi[Ă邩ǂeXg
	 * @param headers L[Ƃăwb_, lƂăwb_ݒlƂȂĂ}bv
	 * @param cr NGXgp[^
	 */
	protected void checkHeaders(Map headers, ClientRequest cr) {
		for(Iterator it = headers.keySet().iterator(); it.hasNext();) {
			String key = (String)it.next();
			assertEquals(headers.get(key), cr.getHeaderValue(key));
		}
	}
}
